###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_valarsoft_webmatic_detect.nasl 6367 2009-12-23 16:25:36Z dec $
#
# Valarsoft Webmatic Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901087);
  script_version("$Revision: 6248 $: 1.0");
  script_name("Valarsoft Webmatic Version Detection");
  desc = "
  Overview: This script finds the running Valarsoft Webmatic version and
  saves the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of Valarsoft Webmatic in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

webmaticPort = get_http_port(default:80);
if(!webmaticPort){
  exit(0);
}

foreach path (make_list("/", "/webmatic", "/web", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:webmaticPort);
  rcvRes = http_send_recv(port:webmaticPort, data:sndReq);
  if("Welcome to Webmatic" >< rcvRes)
  {
    webmaticVer = eregmatch(pattern:"Webmatic ([0-9.]+)", string:rcvRes);
    if(webmaticVer[1] != NULL)
    {
      set_kb_item(name:"www/" + webmaticPort + "/Valarsoft/Webmatic",
                  value:webmaticVer[1] + " under " + path);
    }
  }
}
