##############################################################################
#
#  Sun xVM VirtualBox Insecure Temporary Files Vulnerability (Linux)
#
#  Copyright: SecPod
#
#  Date Written: 2008/12/02
#
#  Revision: 1.0
#
#  Log: sghosal
#  Issue #0535
#
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
##############################################################################

if(description)
{
  script_id(900408);
  script_bugtraq_id(32444);
  script_cve_id("CVE-2008-5256");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0");
  script_category(ACT_GATHER_INFO);
  script_family("General");
  script_name("Sun xVM VirtualBox Insecure Temporary Files Vulnerability (Linux)");
  script_summary("Check for vulnerable version of Sun xVM VirtualBox");
  desc = "
  Overview: This host is installed with Sun xVM VirtualBox and is prone to
  Insecure Temporary Files vulnerability.

  Vulnerability Insight:
  Error is due to insecured handling of temporary files in the 'AcquireDaemonLock'
  function in ipcdUnix.cpp. This allows local users to overwrite arbitrary
  files via a symlink attack on a '/tmp/.vbox-$USER-ipc/lock' temporary file.

  Impact:
  Successful exploitation will let the attacker perform malicious actions
  with the escalated previleges.

  Impact Level: Application

  Affected Software/OS:
  Sun xVM VirutalBox version prior to 2.0.6 versions on all Linux platforms.

  Fix: Upgrade to the latest version 2.0.6 or above.
  http://www.virtualbox.org/wiki/Downloads

  References:
  http://secunia.com/Advisories/32851
  http://www.virtualbox.org/wiki/Changelog

  CVSS Score:
    CVSS Base Score     : 4.4 (AV:L/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/uname");
  exit(0);
}


include("ssh_func.inc");

if("Linux" >!< get_kb_item("ssh/login/uname")){
  exit(0);
}

sock = ssh_login_or_reuse_connection();
if(sock)
{
  xvm_linux = ssh_cmd(socket:sock, cmd:"VBoxDeleteIF -v", timeout:120);
  ssh_close_connection();
  if("VirtualBox" >< xvm_linux){
    pattern = "version ([0-1](\..*)?|2\.0(\.[0-5])?)$";
    if(egrep(pattern:pattern, string:xvm_linux)){
      security_warning(0);
    }
  }
}
