###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_winamp_libsndfile_bof_vuln.nasl 2479 2009-06-01 14:25:38Z june $
#
# Winamp libsndfile Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900558);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1788", "CVE-2009-1791");
  script_bugtraq_id(34978);
  script_name("Winamp libsndfile Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with Winamp and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  The flaw is generated due to boundary error in 'voc_read_header()' and
  'aiff_read_header()' functions in libsndfile.dll while processing VOC
  and AIFF files with invalid header values.

  Impact:
  Attackers may leverage this issue by executing arbitrary codes in the
  context of the affected application via specially crafted VOC, AIFF
  files and can cause denial of service.

  Impact Level: System/Application

  Affected Software/OS:
  Winamp version 5.552 and prior on Windows.

  Fix: Upgrade to the latest libsndfile version or apply the patch.
  http://www.mega-nerd.com/libsndfile/
  http://www.mega-nerd.com/erikd/Blog/CodeHacking/libsndfile/rel_20.html

  *****
  NOTE : Ignore this warning, if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/35076
  http://trapkit.de/advisories/TKADV2009-006.txt
  http://www.vupen.com/english/advisories/2009/1324

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Winamp");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_winamp_detect.nasl");
  script_require_keys("Winamp/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

winampVer = get_kb_item("Winamp/Version");
if(!winampVer){
  exit(0);
}

if(version_is_less_equal(version:winampVer, test_version:"5.5.5.2435")){
   security_hole(0);
}
