###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_winrar_mult_vuln.nasl 4470 2009-09-15 12:40:24Z sep $
#
# WinRAR Multiple Unspecified Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901022);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7144");
  script_name("WinRAR Multiple Unspecified Vulnerabilities");
  desc = "
  Overview: This host has WinRAR installed and is prone to Multiple
  Vulnerability.

  Vulnerability Insight:
  The flaw is due to unspecified errors in the processing of several
  archive files.

  Impact:
  Successful exploitation will let the attacker to cause heap corruptions
  or stack-based buffer overflows or execution of arbitrary code.

  Impact Level: Application

  Affected Software/OS:
  WinRAR versions prior to 3.71

  Fix:  Upgrade to WinRAR version 3.71 or later.
  For updates refer, http://www.rarlab.com/download.htm

  References:
  http://secunia.com/advisories/29407
  http://xforce.iss.net/xforce/xfdb/41251
  http://www.vupen.com/english/advisories/2008/0916/references

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Checks for the version of WinRAR");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_winrar_detect.nasl");
  script_require_keys("WinRAR/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

winrarVer = get_kb_item("WinRAR/Ver");
if(winrarVer != NULL)
{
  # Check for version WinRAR < 3.71 
  if(version_is_less(version:winrarVer, test_version:"3.71")){
     security_hole(0);
   }
}
