#############################################################################
#
#  Wireshark Multiple Vulnerabilities - July08 (Linux)
#
#  Copyright: SecPod
#
#  Date Written: 2008/07/14
#
#  Revision: 1.4 
#
#  Log: schandan
#  Issue #0035
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900011);
 script_bugtraq_id(28485);
 script_cve_id("CVE-2008-1561", "CVE-2008-1562", "CVE-2008-1563");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.4 ");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("Wireshark Multiple Vulnerabilities - July08 (Linux)");
 script_summary("Check for vulnerable version of Wireshark/Ethereal");
 desc = "
 Overview : The host is running Wireshark/Ethereal, which is prone to multiple
 vulnerabilities.

 Vulnerability Insight :

	The flaws exists due to errors in GSM SMS dissector, PANA and KISMET
	dissectors, RTMPT dissector, RMI dissector, and in syslog dissector.

	Impact : Successful exploitation could result in application crash,
	disclose of system memory, and an incomplete syslog encapsulated
	packets.
 
 Impact Level : SYSTEM
 
 Affected Software/OS :
        Wireshark versions prior to 1.0.1 on Linux (All).
 
 Quick Fix : Disable the following dissectors,
 GSM SMS, PANA, KISMET, RTMPT, and RMI
 
 Fix: Upgrade to wireshark to 1.0.1 or later.
 http://www.wireshark.org/download.html
 
 CVSS Score Report :
	CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
	CVSS Temporal Score : 5.3
 Risk factor : High";
 script_description(desc);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/uname");
 exit(0);
}


 include("ssh_func.inc");

 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }

 foreach item (get_kb_list("ssh/*/rpms"))
 {
        if("ethereal" >< item)
	{
        	security_hole(0);
		exit(0);
        }

	else if("wireshark" >< item)
	{
		if(egrep(pattern:"wireshark~(0\.99\.[1-9]|1\.0\.0)($|[^.0-9])",
			 string:item))
                {
                        security_hole(0);
                        exit(0);
                }
        }
 }

 sock = ssh_login_or_reuse_connection();
 if(!sock){
	exit(0);
 }

 etherealVer = ssh_cmd(socket:sock, cmd:"ethereal -v", timeout:120);
 if("Compiled" >< etherealVer)
 {
	if(egrep(pattern:"ethereal 0\.([0-8]?[0-9]\..*|9[0-8]\..*|99\.0)$",
          	 string:etherealVer)){
        	security_warning(0);
 	}
 }

 wiresharkVer = ssh_cmd(socket:sock, cmd:"wireshark -v", timeout:120);
 ssh_close_connection();

 if("Compiled" >< wiresharkVer)
 {
	if(egrep(pattern:"wireshark (0\.99\.[1-9]|1.0.0)$", string:wiresharkVer)){
		security_hole(0);
	}
 }
