#############################################################################
#
#  Wireshark Multiple Vulnerabilities - Sept-08 (Linux)
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/09
#
#  Revision: 1.2
#
#  Log: veerendragg
#  Issue #0172
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

 desc = "
        Impact : Successful exploitation could result in denial of service
        condition or application crash by injecting a series of malformed
        packets or by convincing the victim to read a malformed packet.

 Impact Level : Application

 Affected Software/OS :
        Wireshark versions 1.0.2 and prior on Linux (All).

 Fix : Upgrade to wireshark 1.0.3 or later.
 http://www.wireshark.org/download.html

 References : http://secunia.com/advisories/31674
 http://www.frsirt.com/english/advisories/2008/2493
 http://www.wireshark.org/security/wnpa-sec-2008-05.html

 CVSS Score Report :
        CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
        CVSS Temporal Score : 5.3
 Risk factor : High";
if(description)
{
 script_id(900213);
 script_bugtraq_id(31009);
 script_cve_id("CVE-2008-3146", "CVE-2008-3932", "CVE-2008-3933");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.2 ");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("Wireshark Multiple Vulnerabilities - Sept08 (Linux)");
 script_summary("Check for vulnerable version of Wireshark/Ethereal");
 script_description(desc);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/uname");
 exit(0);
}


 include("ssh_func.inc");

 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }

 report = string("\n Overview : The host is running Wireshark/Ethereal, which" +
                 "is prone to multiple\n vulnerabilities.\n" +
                 "\n        Vulnerability Insight:\n" +
                 "\n        Flaw(s) is/are due to,\n");
 vuln1 = string("       - infinite loop errors in the NCP dissector.\n");
 vuln2 = string("       - an error when uncompressing zlib-compressed packet data.\n");
 vuln3 = string("       - an error when reading a Tektronix .rf5 file.\n");

 foreach item (get_kb_list("ssh/*/rpms"))
 {
        if("ethereal" >< item)
	{
		if(egrep(pattern:"ethereal~0\.(9\.[7-9]|10\.(0?[0-9]|1[0-3]))($|[^.0-9])",
			 string:item))
                {
			security_hole(data:string(report, vuln1, desc));
                        exit(0);
                }
		else if(egrep(pattern:"ethereal~0\.(10\.14|99\.0)($|[^.0-9])", string:item))
		{
			security_hole(data:string(report, vuln1, vuln2, desc));
			exit(0);
		}
        }

	else if("wireshark" >< item)
	{
		if(egrep(pattern:"wireshark~0\.99\.[1-5]($|[^.0-9])", string:item))
                {
			security_hole(data:string(report, vuln1, vuln2, desc));
                        exit(0);
                }
		else if(egrep(pattern:"wireshark~(0\.99\.[6-9]|1\.0\.[0-2])($|[^.0-9])",
			      string:item))
		{
			security_hole(data:string(report, vuln1, vuln2, vuln3, desc));
                        exit(0);
                }
        }
 }

 sock = ssh_login_or_reuse_connection();
 if(!sock){
	exit(0);
 }

 etherealVer = ssh_cmd(socket:sock, cmd:"ethereal -v", timeout:120);
 if("Compiled" >< etherealVer)
 {
	if(egrep(pattern:"ethereal 0\.(9\.[7-9]|10\.(0?[0-9]|1[0-3]))$",
          	 string:etherealVer))
	{
		security_hole(data:string(report, vuln1, desc));
        	security_warning(0);
 	}
	else if(egrep(pattern:"ethereal 0\.(10\.14|99\.0)$", string:etherealVer))
	{
		security_hole(data:string(report, vuln1, vuln2, desc));
                exit(0);
        }
 }

 wiresharkVer = ssh_cmd(socket:sock, cmd:"wireshark -v", timeout:120);
 ssh_close_connection();

 if("Compiled" >< wiresharkVer)
 {
	if(egrep(pattern:"wireshark 0\.99\.[1-5]$", string:wiresharkVer))
	{
		security_hole(data:string(report, vuln1, vuln2, desc));
        	exit(0);
 	}
	else if(egrep(pattern:"(0\.99\.[6-9]|1\.0\.[0-2])$", string:wiresharkVer)){
		security_hole(data:string(report, vuln1, vuln2, vuln3, desc));
	}
 }
