###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_woltlab_burning_board_csrf_vuln.nasl 4615 2009-09-15 11:22:59Z sep $
#
# WoltLab Burning Board Cross-Site Request Forgery Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900937);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7192");
  script_name("WoltLab Burning Board Cross-Site Request Forgery Vulnerability");
  desc = "
  Overview: This host is running WoltLab Burning Board and is prone to
  Cross-Site Request Forgery vulnerability.

  Vulnerability Insight:
  An error arises in index.php due to improper sanitization of user-supplied
  input which may allows remote attackers to hijack the users authentication.

  Impact:
  Attackes can exploit this issue to delete private messages by sending
  malicious input in the 'pmID' parameter in a delete action in a PM page.

  Impact Level: Application

  Affected Software/OS:
  WoltLab Burning Board version 3.x

  Fix: No solution or patch is available as on 14th September 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.woltlab.com/products/burning_board/index_en.php

  References:
  http://xforce.iss.net/xforce/xfdb/39990
  http://www.securityfocus.com/archive/1/archive/1/487139/100/200/threaded

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of WoltLab Burning Board");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_woltlab_burning_board_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

wbbPort = get_http_port(default:80);
if(!wbbPort)
{
  exit(0);
}

wbbVer = get_kb_item("www/" + wbbPort + "/BurningBoard");
wbbVer = eregmatch(pattern:"^(.+) under (/.*)$", string:wbbVer);

if(wbbVer[1] =~ "^3\..*"){
  security_hole(wbbPort);
}
