###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_woltlab_burning_board_detect.nasl 4615 2009-09-15 10:33:18Z sep $
#
# WoltLab Burning Board Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800936);
  script_version("$Revision: 1.0 $");
  script_name("WoltLab Burning Board Version Detection");
  desc = "
  Overview: This script detects the installed version of WoltLab Burning
  Board and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of WoltLab Burning Board");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

wbbPort = get_http_port(default:80);
if(!wbbPort){
  wbbPort = 80;
}

if(!get_port_state(wbbPort))
{
  exit(0);
}

foreach dir (make_list("/", "/wbb", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/upload/index.php"), port:wbbPort);
  rcvRes = http_send_recv(port:wbbPort, data:sndReq);

  if(("WoltLab Burning Board" >< rcvRes) &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    wbbVer = eregmatch(pattern:">Burning Board[&a-z; ]+([0-9.]+" +
                               "([A-Za-z0-9 ]+)?)<", string:rcvRes);
    wbbVer[1] = ereg_replace(pattern:" ", replace:".", string:wbbVer[1]);

    if(wbbVer[1] != NULL)
    {
      set_kb_item(name:"www/" + wbbPort + "/BurningBoard",
                  value:wbbVer[1] + " under " + dir);
    }
  }
}
