##############################################################################
#
#  Ipswitch WS FTP Client Format String Vulnerability   
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/26
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0143
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900206);
 script_bugtraq_id(30720);
 script_cve_id("CVE-2008-3734");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("Ipswitch WS FTP Client Format String Vulnerability");
 script_summary("Check for WS FTP Client version");
 desc = "
 Overview : This host is running WS FTP Client, which is prone to Format String 
 Vulnerability.

 Vulnerability Insight :

        Issue is caused due to a format string error when processing responses
        of the FTP server. 

        Impact : Successful exploitation will allow execution of arbitrary code
        on the vulnerable system or cause the application to crash by tricking
        a user into connecting to a malicious ftp server.

 Impact Level : Application

 Affected Software/OS :
        Ipswitch WS FTP Home/Professional 2007 and prior versions. 

 Fix : No solution/patch is available as on 26th August, 2008. Information
 regarding this issue will update once the solution details are available.
 For updates refer, http://www.ipswitchft.com/products/

 References :
 http://secunia.com/advisories/31504/
 http://xforce.iss.net/xforce/xfdb/44512

 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 6.1
 Risk factor : Medium";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_smb_func.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 wsFtpDir = registry_get_sz(key:"SOFTWARE\Ipswitch\WS_FTP",
                            item:"Dir");
 if(!wsFtpDir)
 {
        wsFtpDir = registry_get_sz(key:"SOFTWARE\Ipswitch\WS_FTP Home",
                                   item:"Dir");
        if(!wsFtpDir){
                exit(0);
        }
        # Set Flag for Home edition.
        wsFtpHome = TRUE;
 }

 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:wsFtpDir);
 file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
		      string:wsFtpDir + "\wsftpgui.exe");

 name    =  kb_smb_name();
 login   =  kb_smb_login();
 pass    =  kb_smb_password();
 domain  =  kb_smb_domain();
 port    =  kb_smb_transport();

 if(!port){
	port = 139;
 }

 if(!get_port_state(port)){
	exit(0);
 }

 soc = open_sock_tcp(port);
 if(!soc){
	exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
 if(!r)
 {
        close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
        close(soc);
        exit(0);
 }

 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(!fid)
 {
        close(soc);
	exit(0);
 }

 fileVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod");
 close(soc);

 if(!fileVer){
	exit(0);
 }

 if(wsFtpHome)
 {
        # Grep Home Edition Version <= 2007.0.0.2
        if(egrep(pattern:"^([01][0-9][0-9][0-9]\..*|200[0-6]\..*|" + 
                         "2007\.0\.0\.[0-2])$", string:fileVer)){
                security_warning(0);
        }
 }
 else
 {
        # Grep Professional Edition Vesion <= 2007.1.0.0
        if(egrep(pattern:"^([01][0-9][0-9][0-9]\..*|200[0-6]\..*|" + 
                         "2007\.[01]\.0\.0)$", string:fileVer)){
                security_warning(0);
        }
 }
