##############################################################################
#
#  xine-lib Multiple Vulnerabilities (Aug-08)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/26
#
#  Revision: 1.3
#
#  Log: schandan
#  Issue #0145
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900041);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.3 ");
 script_category(ACT_GATHER_INFO);
 script_family("Buffer overflow");
 script_name("xine-lib Multiple Vulnerabilities (Aug-08)");
 script_summary("Check for vulnerable version of xine-lib");
 desc = "
 Overview : The host has xine-lib installed, which prone to multiple
 vulnerabilities.

 Vulnerability Insight :
	
        The flaws are due to overflow errors that exist in open_ra_file()
        in demux_realaudio.c, parse_block_group() in demux_matroska.c,
        and eal_parse_audio_specific_data() in demux_real.c methods.
        
        Impact : Remote exploitation could allow execution of arbitrary code
        to cause head-based buffer overflow via a specially crafted RealAudio
        or Matroska file.

 Impact Level : Application/System

 Affected Software/OS :
        xine-lib versions 1.1.15 and prior on Linux (All).

 Fix : No solution/patch is available as on 26th August, 2008. Information
 regarding this issue will updated once the solution details are available.
 For updates refer, http://xinehq.de/index.php/releases

 References : http://secunia.com/advisories/31567/
 http://www.ocert.org/analysis/2008-008/analysis.txt

 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.8 
 Risk factor : Medium";
 script_description(desc);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/uname");
 exit(0);
}


 include("ssh_func.inc");

 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }
 
 foreach item (get_kb_list("ssh/*/rpms"))
 {
        if("xine" >< item)
        {
                if(egrep(pattern:"(libxine(1)?|xine-lib)~(0\..*|1\.(0\..*|" +
				 "1(\.0?[0-9]|\.1[0-5])?))[^.0-9]", string:item))
		{
                        security_warning(0);
			exit(0);
		}
	}
 }

 sock = ssh_login_or_reuse_connection();
 if(!sock){
 	exit(0);
 }

 xineVer = ssh_cmd(socket:sock, cmd:"xine-config --version", timeout:timeout);
 ssh_close_connection();

 if(!xineVer){
 	exit(0);
 }

 if(egrep(pattern:"^(0\..*|1\.(0\..*|1(\.0?[0-9]|\.1[0-5])?))([^.0-9]|$)",
	  string:xineVer)){
 	security_warning(0);
 } 
