###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_xoops_mult_unspecified_vuln_nov09.nasl 5798 2009-11-19 16:07:29Z nov $
#
# XOOPS Multiple Unspecified Vulnerabilities - Nov09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900893);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3963");
  script_bugtraq_id(36955);
  script_name("XOOPS Multiple Unspecified Vulnerabilities - Nov09");
  desc = "
  Overview: This host is running XOOPS and is prone to multiple unspecified
  vulnerabilities.

  Vulnerability Insight:
  The flaws are caused by unspecified errors with unknown impacts and unknown
  attack vectors.

  Impact: Unknow impact

  Impact Level: Application

  Affected Software/OS:
  XOOPS version prior to 2.4.0 Final on all running platform.

  Fix: Upgrade to XOOPS version 2.4.0 Final or later.
  http://www.xoops.org/modules/core/

  References:
  http://xforce.iss.net/xforce/xfdb/54181
  http://www.vupen.com/english/advisories/2009/3174
  http://www.xoops.org/modules/news/article.php?storyid=5064

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of XOOPS");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_xoops_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

xoopsPort = get_http_port(default:80);
if(!xoopsPort){
  exit(0);
}

xoopsVer = get_kb_item("www/"+ xoopsPort + "/XOOPS");
if(!xoopsVer){
  exit(0);
}

xoopsVer = eregmatch(pattern:"^(.+) under (/.*)$", string:xoopsVer);
if(xoopsVer[1])
{
  # Check for XOOPS version prior to 2.4.0 (2.4.0 Final)
  if(version_is_less(version:xoopsVer[1], test_version:"2.4.0")){
    security_hole(xoopsPort);
  }
}
