###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_xpdf_mult_vuln.nasl 1933 2009-04-27 14:21:29Z apr $
#
# Xpdf Multiple Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900457);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(34568, 34791);
  script_cve_id("CVE-2009-0195", "CVE-2009-0166", "CVE-2009-0147", "CVE-2009-0146",
                "CVE-2009-1183", "CVE-2009-1182", "CVE-2009-1181", "CVE-2009-1179",
                "CVE-2009-0800", "CVE-2009-1180", "CVE-2009-0799", "CVE-2009-0165");
  script_name("Xpdf Multiple Vulnerabilities");
  desc = "

  Overview: This host is installed with Xpdf for Linux and is prone to Multiple
  Vulnerabilities.

  Vulnerability Insight:
  - Integer overflow in Xpdf JBIG2 Decoder which allows the attacker create a
    malicious crafted PDF File and causes code execution.
  - Flaws in Xpdf JBIG2 Decoder which causes buffer overflow, freeing of
    arbitrary memory causing Xpdf application to crash.

  Impact:
  Successful exploitation will let the attacker craft a malicious PDF File and
  execute arbitrary codes into the context of the affected application to cause
  denial of service attacks, buffer overflow attacks, remote code executions etc.

  Affected Software/OS:
  Xpdf version 3.02 and prior on Linux.

  Fix:
  Apply Xpdf v3.02 pl3 patch.
  ftp://ftp.foolabs.com/pub/xpdf/xpdf-3.02pl3.patch

  References:
  http://secunia.com/advisories/34755
  https://bugzilla.redhat.com/show_bug.cgi?id=495896
  http://www.redhat.com/support/errata/RHSA-2009-0430.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Xpdf");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_xpdf_detect.nasl");
  script_require_keys("Xpdf/Linux/Ver");
  exit(0);
}


include("version_func.inc");

xpdfVer = get_kb_item("Xpdf/Linux/Ver");
if(xpdfVer == NULL){
  exit(0);
}

# Grep for Xpdf version 3.02 and prior
if(version_is_less_equal(version:xpdfVer, test_version:"3.02")){
  security_hole(0);
}
