###############################################################################
# OpenVAS Vulnerability Test
# $Id: sendmail_37543.nasl 6306 2010-01-04 17:09:12Z mime $
#
# Sendmail NULL Character CA SSL Certificate Validation Security Bypass Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100415);
 script_bugtraq_id(37543);
 script_version ("1.0-$Revision: 6306 $");

 script_name("Sendmail NULL Character CA SSL Certificate Validation Security Bypass Vulnerability");

desc = "Overview:
Sendmail is prone to a security-bypass vulnerability because the
application fails to properly validate the domain name in a signed CA
certificate, allowing attackers to substitute malicious SSL
certificates for trusted ones.

Successfully exploiting this issue allows attackers to perform man-in-the-
middle attacks or impersonate trusted servers, which will aid in
further attacks.

Versions prior to Sendmail 8.14.4 are vulnerable.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/37543
http://www.sendmail.org/releases/8.14.4
http://www.sendmail.org/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Sendmail version is < 8.14.4");
 script_category(ACT_GATHER_INFO);
 script_family("SMTP problems");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("gb_sendmail_detect.nasl");
 script_require_ports("Services/smtp", 25);
 exit(0);
}


include("version_func.inc");

sendmailPort = get_kb_item("Services/smtp");

if(!sendmailPort){
  exit(0);
}

sendmailVer = get_kb_item("SMTP/" + sendmailPort + "/Sendmail");

if(sendmailVer != NULL)
{
  if(version_is_less(version:sendmailVer, test_version:"8.14.4")){
    security_warning(sendmailPort);
    exit(0);
  }
}

exit(0);
