#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: Stefan Esser
#
#  This script is released under the GNU GPL v2
#

if(description)
{
 script_id(15914);
 script_version ("$Revision: 4336 $");
 script_cve_id("CVE-2004-2525");
 script_bugtraq_id(11790);
 script_xref(name:"OSVDB", value:"12177");

 name = "Serendipity XSS Flaw";

 script_name(name);
 
 desc = "
The remote version of Serendipity is vulnerable to cross-site scripting
attacks due to a lack of sanity checks on the 'searchTerm' parameter in
the 'compat.php' script.  With a specially crafted URL, an attacker can
cause arbitrary code execution in a user's browser resulting in a loss
of integrity. 

See also : http://sourceforge.net/tracker/index.php?func=detail&aid=1076762&group_id=75065&atid=542822
Solution : Upgrade to Serendipity 0.7.1 or newer.
Risk factor : Medium";

 script_description(desc);
 
 summary = "Checks for Serendipity XSS flaw";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2004 David Maciejak");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("serendipity_detect.nasl", "cross_site_scripting.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);
if (get_kb_item("www/" + port + "/generic_xss")) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/serendipity"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches)) {
 loc = matches[2];

 req = http_get(item:string(loc, "/index.php?serendipity%5Baction%5D=search&serendipity%5BsearchTerm%5D=%3Cscript%3Efoo%3C%2Fscript%3E"), port:port);			
 r = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( r == NULL )exit(0);
 if ( egrep(pattern:"<script>foo</script>", string:r))
 {
 	security_warning(port);
 }
}
