#
# This script was written by Michael Scheidell SECNAP Network Security
#
# See the Nessus Scripts License for details

if(description)
{
 script_id(11215);
 script_bugtraq_id(6367);
 script_cve_id("CAN-2002-1256");
 script_version("$Revision: 4336 $");

 name = "Flaw in SMB Signing Could Enable Group Policy to be Modified (329170)";

 script_name(name);
 
 desc = "
The SMB signing capability in the Server Message Block
protocol in Microsoft Windows 2000 and Windows XP allows
attackers to disable the digital signing settings in an
SMB session to force the data to be sent unsigned, then
inject data into the session without detection, e.g. by
modifying group policy information sent from a domain
controller.

Maximum Severity Rating: Moderate

Recommendation: Administrators should install the patch immediately. 

Affected Software: 

Microsoft Windows 2000
Microsoft Windows XP

See
http://www.microsoft.com/technet/security/bulletin/ms02-070.mspx

Risk factor : Medium";

 script_description(desc);
 
 summary = "Checks for MS Hotfix 329170";

 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2003 SECNAP Network Security");
 family = "Windows : Microsoft Bulletins";
 script_family(family);
 
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("secpod_reg.inc");

if ( hotfix_check_sp(xp:2) == 0 && hotfix_missing(name:"896422") == 0 ) exit(0);

if ( hotfix_check_sp(nt:7, win2k:4, xp:2) <= 0 ) exit(0);
if ( hotfix_missing(name:"Q329170") > 0 )
	security_warning(get_kb_item("SMB/transport"));
