#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10267);
 script_version ("$Revision: 5872 $");

 name = "SSH Server type and version";
 script_name(name);

 desc = "This detects the SSH Server's type and version by connecting to the server
and processing the buffer received.
This information gives potential attackers additional information about the
system they are attacking. Versions and Types should be omitted
where possible.

Solution: Apply filtering to disallow access to this port from untrusted hosts

 Risk factor : Low";

 script_description(desc);

 summary = "SSH Server type and version";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("This script is Copyright (C) 1999 SecuriTeam");
 family = "General";
 script_family(family);
 script_require_keys("Services/ssh");
 script_dependencies("find_service.nes", "find_service2.nasl", "external_svc_ident.nasl");
 exit(0);
}


#
# The script code starts here
#
include("misc_func.inc");
include("ssh_func.inc");

port = get_kb_item("Services/ssh");

if (!port) port = 22;
if (get_port_state(port))
{
 soc = open_sock_tcp(port);
 if ( ! soc ){
   log_message (data:"An ssh server was discovered running on " + port + ", but now no socket to it could be opened.", port:port);
   exit(0);
 }

 ssh_login (socket:soc, login:"OpenVAS", password:"OpenVAS", pub:NULL, priv:NULL, passphrase:NULL);

 version = get_ssh_server_version ();
 banner  = get_ssh_banner ();
 supported = get_ssh_supported_authentication ();
 text = "";

 if (!version)
   text = "An ssh server with unknown version was found running on this port.";
 else
 {
   set_kb_item(name:"SSH/banner/" + port, value:version);
   text = "Remote SSH version : " + version + '\n\n';

   if (supported)
   {
     set_kb_item(name:"SSH/supportedauth/" + port, value:supported);
     text += 'Remote SSH supported authentication : ' + supported + '\n\n';
   }

   if (banner)
   {
     set_kb_item(name:"SSH/textbanner/" + port, value:banner);
     text += 'Remote SSH banner : \n' + banner + '\n\n';
   }

   register_service(port: port, proto: "ssh");
 }

 security_note(port:port, data:text);
 close(soc);
}
else{
  log_message (data:"An ssh server was discovered or assumed to be running on " + port + ", but the port seems to be closed now.", port:port);
}

exit(0);
