###############################################################################
# OpenVAS Vulnerability Test
# $Id: testlink_37258.nasl 6125 2009-12-10 17:09:58Z mime $
#
# TestLink Cross Site Scripting and SQL Injection Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100390);
 script_bugtraq_id(37258);
 script_cve_id("CVE-2009-4237","CVE-2009-4238");
 script_version ("1.0-$Revision: 6125 $");

 script_name("TestLink Cross Site Scripting and SQL Injection Vulnerabilities");

desc = "Overview:
TestLink is prone to multiple SQL-injection and cross-site scripting
vulnerabilities because it fails to sufficiently sanitize user-
supplied data.

Exploiting these issues could allow an attacker to steal cookie-
based authentication credentials, compromise the application,
access or modify data, or exploit latent vulnerabilities in the
underlying database.

Versions prior to TestLink 1.8.5 are vulnerable.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/37258
http://www.teamst.org/index.php?option=com_content&task=view&id=84&Itemid=2
http://www.teamst.org/
http://www.coresecurity.com/content/testlink-multiple-injection-vulnerabilities


Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if TestLink version is < 1.8.5");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("testlink_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/testlink")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "1.8.5")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
