# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-700-1 (perl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63075);
 script_cve_id("CVE-2007-4829", "CVE-2008-1927", "CVE-2008-5302", "CVE-2008-5303");
 script_version ("$");
 name = "Ubuntu USN-700-1 (perl)";
 script_name(name);

 desc = "The remote host is missing an update to perl
announced via advisory USN-700-1.

Details follow:

Jonathan Smith discovered that the Archive::Tar Perl module did not
correctly handle symlinks when extracting archives.  If a user or
automated system were tricked into opening a specially crafted tar file,
a remote attacker could over-write arbitrary files.  (CVE-2007-4829)

Tavis Ormandy and Will Drewry discovered that Perl did not correctly
handle certain utf8 characters in regular expressions.  If a user or
automated system were tricked into using a specially crafted expression,
a remote attacker could crash the application, leading to a denial
of service.  Ubuntu 8.10 was not affected by this issue.  (CVE-2008-1927)

A race condition was discovered in the File::Path Perl module's rmtree
function.  If a local attacker successfully raced another user's call
of rmtree, they could create arbitrary setuid binaries.  Ubuntu 6.06
and 8.10 were not affected by this issue.  (CVE-2008-5302)

A race condition was discovered in the File::Path Perl module's rmtree
function.  If a local attacker successfully raced another user's call of
rmtree, they could delete arbitrary files.  Ubuntu 6.06 was not affected
by this issue.  (CVE-2008-5303)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libarchive-tar-perl             1.26-2ubuntu0.1
  libperl5.8                      5.8.7-10ubuntu1.2

Ubuntu 7.10:
  libarchive-tar-perl             1.31-1ubuntu0.1
  libperl5.8                      5.8.8-7ubuntu3.4
  perl-modules                    5.8.8-7ubuntu3.4

Ubuntu 8.04 LTS:
  libarchive-tar-perl             1.36-1ubuntu0.1
  libperl5.8                      5.8.8-12ubuntu0.3
  perl-modules                    5.8.8-12ubuntu0.3

Ubuntu 8.10:
  perl-modules                    5.10.0-11.1ubuntu2.2

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-700-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-700-1 (perl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libarchive-tar-perl", ver:"1.26-2ubuntu0.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.8.7-10ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-modules", ver:"5.8.7-10ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.8.7-10ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.8.7-10ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.8", ver:"5.8.7-10ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.8.7-10ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.8.7-10ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.8.7-10ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.8.7-10ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarchive-tar-perl", ver:"1.31-1ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.8.8-7ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-modules", ver:"5.8.8-7ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.8.8-7ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.8.8-7ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.8", ver:"5.8.8-7ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.8.8-7ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.8.8-7ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.8.8-7ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.8.8-7ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libarchive-tar-perl", ver:"1.36-1ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.8.8-12ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-modules", ver:"5.8.8-12ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.8.8-12ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.8.8-12ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.8", ver:"5.8.8-12ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.8.8-12ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.8.8-12ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.8.8-12ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.8.8-12ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.10.0-11.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-modules", ver:"5.10.0-11.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.10.0-11.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.10.0-11.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.10", ver:"5.10.0-11.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.10.0-11.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.10.0-11.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.10.0-11.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.10.0-11.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
