# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-743-1 (gs-gpl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64169);
 script_cve_id("CVE-2009-0583", "CVE-2009-0584", "CVE-2009-0581", "CVE-2009-0723", "CVE-2009-0733", "CVE-2009-0920", "CVE-2009-0921", "CVE-2009-0927", "CVE-2009-0207", "CVE-2009-0928", "CVE-2009-0193", "CVE-2009-0629", "CVE-2009-0626", "CVE-2009-0628", "CVE-2009-0635", "CVE-2009-0633", "CVE-2009-0634", "CVE-2009-0637", "CVE-2009-0784", "CVE-2009-0698", "CVE-2008-5239", "CVE-2008-1036", "CVE-2008-4316", "CVE-2006-2426", "CVE-2009-1093", "CVE-2009-1094", "CVE-2009-1095", "CVE-2009-1096", "CVE-2009-1097", "CVE-2009-1098", "CVE-2009-1100", "CVE-2009-1101", "CVE-2009-1102");
 script_version ("$");
 name = "Ubuntu USN-743-1 (gs-gpl)";
 script_name(name);

 desc = "The remote host is missing an update to gs-gpl
announced via advisory USN-743-1.

Details follow:

It was discovered that Ghostscript contained multiple integer overflows in
its ICC color management library. If a user or automated system were
tricked into opening a crafted Postscript file, an attacker could cause a
denial of service or execute arbitrary code with privileges of the user
invoking the program. (CVE-2009-0583)

It was discovered that Ghostscript did not properly perform bounds checking
in its ICC color management library. If a user or automated system were
tricked into opening a crafted Postscript file, an attacker could cause a
denial of service or execute arbitrary code with privileges of the user
invoking the program. (CVE-2009-0584)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  gs-gpl                          8.15-4ubuntu3.2

Ubuntu 7.10:
  libgs8                          8.61.dfsg.1~svn8187-0ubuntu3.5

Ubuntu 8.04 LTS:
  libgs8                          8.61.dfsg.1-1ubuntu3.1

Ubuntu 8.10:
  libgs8                          8.63.dfsg.1-0ubuntu6.3

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-743-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-743-1 (gs-gpl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gs", ver:"8.15-4ubuntu3.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-gpl", ver:"8.15-4ubuntu3.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-doc", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp-x", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-gpl", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs-esp-dev", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-aladdin", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-common", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-x", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs-dev", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs8", ver:"8.61.dfsg.1~svn8187-0ubuntu3.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-doc", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-gpl", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs-esp-dev", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-aladdin", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-common", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp-x", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-x", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs-dev", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs8", ver:"8.61.dfsg.1-1ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-doc", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-common", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-gpl", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs-esp-dev", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-aladdin", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp-x", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-x", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs-dev", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs8", ver:"8.63.dfsg.1-0ubuntu6.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms1-dev", ver:"1.13-1ubuntu0.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms1", ver:"1.13-1ubuntu0.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms-utils", ver:"1.13-1ubuntu0.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms1-dev", ver:"1.16-5ubuntu3.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms1", ver:"1.16-5ubuntu3.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms-utils", ver:"1.16-5ubuntu3.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-liblcms", ver:"1.16-5ubuntu3.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms1-dev", ver:"1.16-7ubuntu1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms1", ver:"1.16-7ubuntu1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms-utils", ver:"1.16-7ubuntu1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-liblcms", ver:"1.16-7ubuntu1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms1-dev", ver:"1.17.dfsg-1+lenny2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms1", ver:"1.17.dfsg-1+lenny2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblcms-utils", ver:"1.17.dfsg-1+lenny2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-liblcms", ver:"1.17.dfsg-1+lenny2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"systemtap", ver:"0.0.20080705-1+lenny1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine-dev", ver:"1.1.1+ubuntu2-7.11", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine-main1", ver:"1.1.1+ubuntu2-7.11", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine-dev", ver:"1.1.7-1ubuntu1.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-doc", ver:"1.1.7-1ubuntu1.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-plugins", ver:"1.1.7-1ubuntu1.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-dbg", ver:"1.1.7-1ubuntu1.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1", ver:"1.1.7-1ubuntu1.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-console", ver:"1.1.7-1ubuntu1.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-ffmpeg", ver:"1.1.7-1ubuntu1.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-gnome", ver:"1.1.7-1ubuntu1.5", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-doc", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-all-plugins", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-plugins", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine-dev", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-bin", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-console", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-dbg", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-misc-plugins", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-x", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-ffmpeg", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-gnome", ver:"1.1.11.1-1ubuntu3.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-doc", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-all-plugins", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-plugins", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine-dev", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-bin", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-console", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-dbg", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-ffmpeg", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-gnome", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-misc-plugins", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1-x", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxine1", ver:"1.1.15-0ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"icu-doc", ver:"3.4.1a-1ubuntu1.6.06.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu34-dev", ver:"3.4.1a-1ubuntu1.6.06.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu34", ver:"3.4.1a-1ubuntu1.6.06.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"icu-doc", ver:"3.6-3ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu36-dev", ver:"3.6-3ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu36", ver:"3.6-3ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"icu-doc", ver:"3.8-6ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib32icu-dev", ver:"3.8-6ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib32icu38", ver:"3.8-6ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu-dev", ver:"3.8-6ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu38-dbg", ver:"3.8-6ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu38", ver:"3.8-6ubuntu0.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"icu-doc", ver:"3.8.1-2ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib32icu-dev", ver:"3.8.1-2ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib32icu38", ver:"3.8.1-2ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu-dev", ver:"3.8.1-2ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu38-dbg", ver:"3.8.1-2ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu38", ver:"3.8.1-2ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-doc", ver:"6b12-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-jre-lib", ver:"6b12-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-source", ver:"6b12-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-source-files", ver:"6b12-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"icedtea6-plugin", ver:"6b12-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-dbg", ver:"6b12-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-demo", ver:"6b12-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-jdk", ver:"6b12-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-jre-headless", ver:"6b12-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openjdk-6-jre", ver:"6b12-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
