# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-750-1 (openssl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63751);
 script_cve_id("CVE-2009-0590");
 script_version ("$");
 name = "Ubuntu USN-750-1 (openssl)";
 script_name(name);

 desc = "The remote host is missing an update to openssl
announced via advisory USN-750-1.

Details follow:

It was discovered that OpenSSL did not properly validate the length of an
encoded BMPString or UniversalString when printing ASN.1 strings. If a user
or automated system were tricked into processing a crafted certificate, an
attacker could cause a denial of service via application crash in
applications linked against OpenSSL.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libssl0.9.8                     0.9.8a-7ubuntu0.7

Ubuntu 7.10:
  libssl0.9.8                     0.9.8e-5ubuntu3.4

Ubuntu 8.04 LTS:
  libssl0.9.8                     0.9.8g-4ubuntu3.5

Ubuntu 8.10:
  libssl0.9.8                     0.9.8g-10.1ubuntu2.2

After a standard system upgrade you need to reboot your computer to
effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-750-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-750-1 (openssl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8a-7ubuntu0.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8a-7ubuntu0.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8a-7ubuntu0.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.8a-7ubuntu0.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8e-5ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8e-5ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8e-5ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.8e-5ubuntu3.4", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl-doc", ver:"0.9.8g-4ubuntu3.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8g-4ubuntu3.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8g-4ubuntu3.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8g-4ubuntu3.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.8g-4ubuntu3.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl-doc", ver:"0.9.8g-10.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8g-10.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8g-10.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8g-10.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.8g-10.1ubuntu2.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
