# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-753-1 (postgresql-8.3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63811);
 script_cve_id("CVE-2009-0922", "CVE-2008-4307", "CVE-2008-6107", "CVE-2009-0028", "CVE-2009-0029", "CVE-2009-0065", "CVE-2009-0322", "CVE-2009-0675", "CVE-2009-0676", "CVE-2009-0834", "CVE-2009-0835", "CVE-2009-0859");
 script_version ("$");
 name = "Ubuntu USN-753-1 (postgresql-8.3)";
 script_name(name);

 desc = "The remote host is missing an update to postgresql-8.3
announced via advisory USN-753-1.

Details follow:

It was discovered that PostgreSQL did not properly handle encoding
conversion failures. An attacker could exploit this by sending specially
crafted requests to PostgreSQL, leading to a denial of service.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  postgresql-8.1                  8.1.17-0ubuntu0.6.06.1

Ubuntu 8.04 LTS:
  postgresql-8.3                  8.3.7-0ubuntu8.04.1

Ubuntu 8.10:
  postgresql-8.3                  8.3.7-0ubuntu8.10.1

This update uses a new upstream release, which includes additional
bug fixes. In general, a standard system upgrade is sufficient to
effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-753-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-753-1 (postgresql-8.3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postgresql-doc-8.1", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq4", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-8.1", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-8.1", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-8.1", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-8.1", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-8.1", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-8.1", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-8.1", ver:"8.1.17-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc-8.3", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-compat3", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg6", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtypes3", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq-dev", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq5", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-8.3", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-8.3", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-8.3", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-8.3", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-8.3", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-8.3", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-8.3", ver:"8.3.7-0ubuntu8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc-8.3", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-compat3", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg6", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtypes3", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq-dev", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq5", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-8.3", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-8.3", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-8.3", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-8.3", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-8.3", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-8.3", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-8.3", ver:"8.3.7-0ubuntu8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-source", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-doc-2.6.15", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-source-2.6.15", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-common", ver:"2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-amd64-generic", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-amd64-k8", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-amd64-server", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-amd64-xeon", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-amd64-generic", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-amd64-k8", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-amd64-server", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-amd64-xeon", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-amd64-generic", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-amd64-k8", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-amd64-server", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-amd64-xeon", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-amd64-generic", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-amd64-k8", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-amd64-server", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-amd64-xeon", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-amd64-generic", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-amd64-k8", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-amd64-server", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-amd64-xeon", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-amd64-generic", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-amd64-k8", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-amd64-server", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-amd64-xeon", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"avm-fritz-kernel-source", ver:"3.11+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fglrx-kernel-source", ver:"8.25.18+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nvidia-kernel-source", ver:"1.0.8776+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nvidia-legacy-kernel-source", ver:"1.0.7174+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"avm-fritz-firmware", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-amd64-generic", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-amd64-k8-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-amd64-k8", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-amd64-server", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-amd64-xeon", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-amd64-generic", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-amd64-k8", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-amd64-xeon", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"avm-fritz-firmware-2.6.15-54", ver:"3.11+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fglrx-control", ver:"8.25.18+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-2.6.15-54-amd64-generic", ver:"2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-2.6.15-54-amd64-k8", ver:"2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-2.6.15-54-amd64-xeon", ver:"2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nvidia-glx-dev", ver:"1.0.8776+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nvidia-glx-legacy-dev", ver:"1.0.7174+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nvidia-glx-legacy", ver:"1.0.7174+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nvidia-glx", ver:"1.0.8776+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xorg-driver-fglrx-dev", ver:"7.0.0-8.25.18+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xorg-driver-fglrx", ver:"7.0.0-8.25.18+2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-386", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-686", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-k7", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-server-bigiron", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-server", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-386", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-686", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-k7", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-server-bigiron", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-server", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-386", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-686", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-k7", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-server-bigiron", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-server", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-386", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-686", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-k7", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-server-bigiron", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-server", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-386", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-686", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-k7", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-server-bigiron", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-server", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-386", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-686", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-k7", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-server-bigiron", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-server", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-386", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-686-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-686", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-k7-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-k7", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-386", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-686", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-k7", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-server-bigiron", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-server", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-2.6.15-54-386", ver:"2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-2.6.15-54-686", ver:"2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-2.6.15-54-k7", ver:"2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-powerpc-smp", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-powerpc64-smp", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-powerpc", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-powerpc-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-powerpc64-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-powerpc", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-power3-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-power3", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-power4-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-power4", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-powerpc-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-powerpc64-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-powerpc", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-power3-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-power3", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-power4-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-power4", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-powerpc-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-powerpc64-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-powerpc", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-powerpc-smp", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-powerpc64-smp", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-powerpc", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-powerpc-smp", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-powerpc64-smp", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-powerpc", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-power3-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-power3", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-power4-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-power4", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-powerpc-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-powerpc64-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-powerpc", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-powerpc-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-powerpc", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-2.6.15-54-powerpc-smp", ver:"2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-2.6.15-54-powerpc", ver:"2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-sparc64-smp", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-2.6.15-54-sparc64", ver:"2.6.15-54.12", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-sparc64-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-backports-modules-sparc64", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-sparc64-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-sparc64", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-sparc64-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-sparc64", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-sparc64-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-sparc64", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-sparc64-smp", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.15-54-sparc64", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-sparc64-smp", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.15-54-sparc64", ver:"2.6.15-54.76", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-sparc64-smp", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-sparc64", ver:"2.6.15.55", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-2.6.15-54-sparc64-smp", ver:"2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-restricted-modules-2.6.15-54-sparc64", ver:"2.6.15.12-54.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
