# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-755-1 (krb5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63814);
 script_cve_id("CVE-2009-0844", "CVE-2009-0845", "CVE-2009-0846", "CVE-2009-0847");
 script_version ("$");
 name = "Ubuntu USN-755-1 (krb5)";
 script_name(name);

 desc = "The remote host is missing an update to krb5
announced via advisory USN-755-1.

Details follow:

Multiple flaws were discovered in the Kerberos GSS-API and ASN.1 routines
that did not correctly handle certain requests. An unauthenticated remote
attacker could send specially crafted traffic to crash services using
the Kerberos library, leading to a denial of service.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libkadm55                       1.4.3-5ubuntu0.8
  libkrb53                        1.4.3-5ubuntu0.8

Ubuntu 7.10:
  libkadm55                       1.6.dfsg.1-7ubuntu0.2
  libkrb53                        1.6.dfsg.1-7ubuntu0.2

Ubuntu 8.04 LTS:
  libkadm55                       1.6.dfsg.3~beta1-2ubuntu1.1
  libkrb53                        1.6.dfsg.3~beta1-2ubuntu1.1

Ubuntu 8.10:
  libkadm55                       1.6.dfsg.4~beta1-3ubuntu0.1
  libkrb53                        1.6.dfsg.4~beta1-3ubuntu0.1

After a standard system upgrade you need to restart any services using
the Kerberos libraries to effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-755-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-755-1 (krb5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"krb5-doc", ver:"1.4.3-5ubuntu0.8", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm55", ver:"1.4.3-5ubuntu0.8", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.4.3-5ubuntu0.8", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb53", ver:"1.4.3-5ubuntu0.8", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.4.3-5ubuntu0.8", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-clients", ver:"1.4.3-5ubuntu0.8", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.4.3-5ubuntu0.8", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.4.3-5ubuntu0.8", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.4.3-5ubuntu0.8", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.4.3-5ubuntu0.8", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-user", ver:"1.4.3-5ubuntu0.8", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-doc", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm55", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb53", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-clients", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-user", ver:"1.6.dfsg.1-7ubuntu0.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-doc", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-user", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm55", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb53", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-clients", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-pkinit", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.6.dfsg.3~beta1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-doc", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-user", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm55", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb53", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-clients", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc-ldap", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-pkinit", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.6.dfsg.4~beta1-3ubuntu0.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
