# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-783-1 (ecryptfs-utils)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64190);
 script_cve_id("CVE-2009-1296");
 script_version ("$");
 name = "Ubuntu USN-783-1 (ecryptfs-utils)";
 script_name(name);

 desc = "The remote host is missing an update to ecryptfs-utils
announced via advisory USN-783-1.

Details follow:

Chris Jones discovered that the eCryptfs support utilities would
report the mount passphrase into installation logs when an eCryptfs
home directory was selected during Ubuntu installation.  The logs are
only readable by the root user, but this still left the mount passphrase
unencrypted on disk, potentially leading to a loss of privacy.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 9.04:
  ecryptfs-utils                  73-0ubuntu6.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-783-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-783-1 (ecryptfs-utils)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ecryptfs-utils", ver:"73-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecryptfs-dev", ver:"73-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecryptfs0", ver:"73-0ubuntu6.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
