# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-813-2 (apache2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64653);
 script_cve_id("CVE-2009-2412");
 script_version ("$Revision$");
 script_name("Ubuntu USN-813-2 (apache2)");

 desc = "The remote host is missing an update to apache2
announced via advisory USN-813-2.

Details follow:

USN-813-1 fixed vulnerabilities in apr. This update provides the
corresponding updates for apr as provided by Apache on Ubuntu 6.06 LTS.

Original advisory details:

 Matt Lewis discovered that apr did not properly sanitize its input when
 allocating memory. If an application using apr processed crafted input, a
 remote attacker could cause a denial of service or potentially execute
 arbitrary code as the user invoking the application.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libapr0                         2.0.55-4ubuntu2.7

After a standard system upgrade you need to restart any applications using
apr, such as Subversion and Apache, to effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-813-2

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-813-2 (apache2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.0.55-4ubuntu2.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-common", ver:"2.0.55-4ubuntu2.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.0.55-4ubuntu2.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.0.55-4ubuntu2.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.0.55-4ubuntu2.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.0.55-4ubuntu2.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.0.55-4ubuntu2.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.0.55-4ubuntu2.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.0.55-4ubuntu2.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapr0-dev", ver:"2.0.55-4ubuntu2.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapr0", ver:"2.0.55-4ubuntu2.7", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
