# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-822-1 (kdelibs)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64778);
 script_cve_id("CVE-2009-0945", "CVE-2009-1687", "CVE-2009-1690", "CVE-2009-1698");
 script_version ("$");
 script_name("Ubuntu USN-822-1 (kdelibs)");

 desc = "The remote host is missing an update to kdelibs
announced via advisory USN-822-1.

Details follow:

It was discovered that KDE-Libs did not properly handle certain malformed
SVG images. If a user were tricked into opening a specially crafted SVG
image, an attacker could cause a denial of service or possibly execute
arbitrary code with the privileges of the user invoking the program. This
issue only affected Ubuntu 9.04. (CVE-2009-0945)

It was discovered that the KDE JavaScript garbage collector did not
properly handle memory allocation failures. If a user were tricked into
viewing a malicious website, an attacker could cause a denial of service or
possibly execute arbitrary code with the privileges of the user invoking
the program. (CVE-2009-1687)

It was discovered that KDE-Libs did not properly handle HTML content in the
head element. If a user were tricked into viewing a malicious website, an
attacker could cause a denial of service or possibly execute arbitrary code
with the privileges of the user invoking the program. (CVE-2009-1690)

It was discovered that KDE-Libs did not properly handle the Cascading Style
Sheets (CSS) attr function call. If a user were tricked into viewing a
malicious website, an attacker could cause a denial of service or possibly
execute arbitrary code with the privileges of the user invoking the
program. (CVE-2009-1698)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  kdelibs4c2a                     4:3.5.10-0ubuntu1~hardy1.2

Ubuntu 8.10:
  kdelibs4c2a                     4:3.5.10-0ubuntu6.1
  kdelibs5                        4:4.1.4-0ubuntu1~intrepid1.2

Ubuntu 9.04:
  kdelibs4c2a                     4:3.5.10.dfsg.1-1ubuntu8.1
  kdelibs5                        4:4.2.2-0ubuntu5.1

After a standard system upgrade you need to restart your session to effect
the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-822-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-822-1 (kdelibs)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.10-0ubuntu1~hardy1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.5.10-0ubuntu1~hardy1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.10-0ubuntu1~hardy1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.10-0ubuntu1~hardy1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.10-0ubuntu1~hardy1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.10-0ubuntu1~hardy1.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs5-data", ver:"4.1.4-0ubuntu1~intrepid1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs5-doc", ver:"4.1.4-0ubuntu1~intrepid1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.10-0ubuntu6.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.5.10-0ubuntu6.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.10-0ubuntu6.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-bin", ver:"4.1.4-0ubuntu1~intrepid1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs5-dbg", ver:"4.1.4-0ubuntu1~intrepid1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs5-dev", ver:"4.1.4-0ubuntu1~intrepid1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs5", ver:"4.1.4-0ubuntu1~intrepid1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.10-0ubuntu6.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.10-0ubuntu6.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.10-0ubuntu6.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs5-data", ver:"4.2.2-0ubuntu5.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.10.dfsg.1-1ubuntu8.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.10.dfsg.1-1ubuntu8.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-bin", ver:"4.2.2-0ubuntu5.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs5-dbg", ver:"4.2.2-0ubuntu5.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs5-dev", ver:"4.2.2-0ubuntu5.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs5", ver:"4.2.2-0ubuntu5.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libplasma-dev", ver:"4.2.2-0ubuntu5.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libplasma3", ver:"4.2.2-0ubuntu5.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.10.dfsg.1-1ubuntu8.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.10.dfsg.1-1ubuntu8.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.10.dfsg.1-1ubuntu8.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
