# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-832-1 (freeradius)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64926);
 script_cve_id("CVE-2009-3111");
 script_version ("$");
 script_name("Ubuntu USN-832-1 (freeradius)");

 desc = "The remote host is missing an update to freeradius
announced via advisory USN-832-1.

Details follow:

It was discovered that FreeRADIUS did not correctly handle certain 
malformed attributes. A remote attacker could exploit this flaw and cause
the FreeRADIUS server to crash, resulting in a denial of service.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  freeradius                      1.1.7-1ubuntu0.2

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-832-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-832-1 (freeradius)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"freeradius-dialupadmin", ver:"1.1.7-1ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-dbg", ver:"1.1.7-1ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-iodbc", ver:"1.1.7-1ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-krb5", ver:"1.1.7-1ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-ldap", ver:"1.1.7-1ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-mysql", ver:"1.1.7-1ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-postgresql", ver:"1.1.7-1ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius", ver:"1.1.7-1ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
