# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-863-1 (qemu-kvm)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(66462);
 script_version ("$Revision$");
 script_name("Ubuntu USN-863-1 (qemu-kvm)");

 desc = "The remote host is missing an update to qemu-kvm
announced via advisory USN-863-1.

Details follow:

It was discovered that QEMU did not properly setup the virtio networking
features available to its guests. A remote attacker could exploit this to
crash QEMU guests which use virtio networking on Linux kernels earlier
than 2.6.26.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 9.10:
  qemu-kvm                        0.11.0-0ubuntu6.3

After a standard system upgrade you need to restart any QEMU guests to
effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-863-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-863-1 (qemu-kvm)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kvm", ver:"84+dfsg-0ubuntu16+0.11.0+0ubuntu6.3", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qemu-kvm", ver:"0.11.0-0ubuntu6.3", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qemu-arm-static", ver:"0.11.0-0ubuntu6.3", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qemu-kvm-extras", ver:"0.11.0-0ubuntu6.3", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qemu", ver:"0.11.0-0ubuntu6.3", rls:"UBUNTU9.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
