###############################################################################
# OpenVAS Vulnerability Test
# $Id: wordpress_38368.nasl 6823 2010-02-24 17:35:31Z mime $
#
# WordPress Trashed Posts Information Disclosure Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100505);
 script_bugtraq_id(38368);
 script_cve_id("CVE-2010-0682");
 script_version ("1.0-$Revision: 6823 $");

 script_name("WordPress Trashed Posts Information Disclosure Vulnerability");

desc = "Overview:
WordPress is prone to an information-disclosure vulnerability because
it fails to properly restrict access to trashed posts.

An attacker can exploit this vulnerability to view other authors'
trashed posts, which may aid in further attacks.

Versions prior to WordPress 2.9.2 are vulnerable.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/38368
http://tmacuk.co.uk/?p=180
http://wordpress.org/development/2010/02/wordpress-2-9-2/
http://wordpress.org/

Risk factor : Low";

 script_description(desc);
 script_summary("Determine if WordPress version is < 2.9.2");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("secpod_wordpress_detect_900182.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/WordPress")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "2.9.2")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
