#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#
# I thought of putting both tests in a file, but that's quicker like this
# I think


if(description)
{
  script_id(11120);
  script_version ("$Revision: 4340 $");
 
  script_name("xtelw detection");
 
  desc = "
xteld is running on this port in HyperTerminal mode. 
This service allows users to connect to the 'Teletel' network. 
Some of the servers are expensive. 
Note that by default, xteld forbids access to the most expensive 
services.

Risk factor : None";



 script_description(desc);
 
  summary = "Detect xteld in HyperTerminal mode";
 script_summary(summary);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright("This script is Copyright (C) 2002 Michel Arboi");
  script_family("Service detection");
  script_dependencie("find_service.nes");
  script_require_ports("Services/unknown", 1314);

  exit(0);
}

#

include("misc_func.inc");

# Quick way
port=1314;
# Slow way
#port = get_kb_item("Services/unknown"); 
#if (! port) { port=1314; }

if (! get_port_state(port)) exit(0);
if (! service_is_unknown(port: port)) exit(0);

banner = get_unknown_banner(port: port, dontfetch:0);
if (! banner) exit(0);

# I'm too lazy to parse the service list :-)
if (("Service Minitel" >< banner) && ("Xteld" >< banner))
{
 security_note(port);
 register_service(port: port, proto: "xtelw");
}


