# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 211-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53452);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 211-1 (micq)";
 script_name(name);

 desc = "The remote host is missing an update to micq
announced via advisory DSA 211-1.

Rdiger Kuhlmann, upstream developer of mICQ, a text based ICQ client,
discovered a problem in mICQ.  Receiving certain ICQ message types
that do not contain the required 0xFE seperator causes all versions to
crash.

For the current stable distribution (woody) this problem has been
fixed in version 0.4.9-0woody3.

For the old stable distribution (potato) this problem has been fixed
in version 0.4.3-4.1.

For the current unstable distribution (sid) this problem has been
fixed in version 0.4.9.1-1.

We recommend that you upgrade your micq package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20211-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 211-1 (micq)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"micq", ver:"0.4.3-4.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"micq", ver:"0.4.9-0woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
