###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdebase4-workspace MDVA-2008:156 (kdebase4-workspace)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830444);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2008:156");
  script_name( "Mandriva Update for kdebase4-workspace MDVA-2008:156 (kdebase4-workspace)");
  desc = "

  Vulnerability Insight:

  This update adds the auto-hide feature to the KDE4 desktop panel.

  Affected Software/OS:
  kdebase4-workspace on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00036.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdebase4-workspace");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"kdebase4-workspace", rpm:"kdebase4-workspace~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase4-workspace-devel", rpm:"kdebase4-workspace-devel~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdm", rpm:"kdm~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdecorations4", rpm:"libkdecorations4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkfontinst4", rpm:"libkfontinst4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkfontinstui4", rpm:"libkfontinstui4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkhotkeysprivate4", rpm:"libkhotkeysprivate4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkscreensaver5", rpm:"libkscreensaver5~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libksgrd4", rpm:"libksgrd4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkwineffects1", rpm:"libkwineffects1~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkwinnvidiahack4", rpm:"libkwinnvidiahack4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkworkspace4", rpm:"libkworkspace4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libplasma2", rpm:"libplasma2~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libplasmaclock4", rpm:"libplasmaclock4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libprocesscore4", rpm:"libprocesscore4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libprocessui4", rpm:"libprocessui4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsolidcontrol4", rpm:"libsolidcontrol4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsolidcontrolifaces4", rpm:"libsolidcontrolifaces4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtaskmanager4", rpm:"libtaskmanager4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libweather_ion4", rpm:"libweather_ion4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdecorations4", rpm:"lib64kdecorations4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kfontinst4", rpm:"lib64kfontinst4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kfontinstui4", rpm:"lib64kfontinstui4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64khotkeysprivate4", rpm:"lib64khotkeysprivate4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kscreensaver5", rpm:"lib64kscreensaver5~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ksgrd4", rpm:"lib64ksgrd4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kwineffects1", rpm:"lib64kwineffects1~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kwinnvidiahack4", rpm:"lib64kwinnvidiahack4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kworkspace4", rpm:"lib64kworkspace4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64plasma2", rpm:"lib64plasma2~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64plasmaclock4", rpm:"lib64plasmaclock4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64processcore4", rpm:"lib64processcore4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64processui4", rpm:"lib64processui4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64solidcontrol4", rpm:"lib64solidcontrol4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64solidcontrolifaces4", rpm:"lib64solidcontrolifaces4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64taskmanager4", rpm:"lib64taskmanager4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64weather_ion4", rpm:"lib64weather_ion4~4.1.2~13.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}