#include "transmenu.h"
#include <qlayout.h>
#include <kapp.h>
#include <ksimpleconfig.h>
#include <kconfig.h>
#include <klocale.h>
#include <qvbuttongroup.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qlabel.h>
#include <kcolorbutton.h>
#include <kipc.h>

void TransMenuConfig::save()
{
    KConfig *config = KGlobal::config();
    config->setGroup("MosfetMenus");
    int id = btnGroup->id(btnGroup->selected());
    config->writeEntry("Type", id, 1, 1);
    config->writeEntry("ShadowText", shadowBtn->isChecked(), 1, 1);
    if(id == Custom){
        config->writeEntry("Color", colorBtn->color(), 1, 1);
        config->writeEntry("TextColor", fgBtn->color(), 1, 1);
        config->writeEntry("Opacity", opacitySlider->value(), 1, 1);
    }
    config->sync();
    emit changed(false);
    KIPC::sendMessageAll((KIPC::Message)LIQUID_MENU_CHANGE, 0);
}


void TransMenuConfig::load()
{
    KConfig *config = KGlobal::config();
    config->setGroup("MosfetMenus");

    int id = config->readNumEntry("Type", TransStippleBg);
    btnGroup->setButton(id);
    colorBtn->setColor(config->readColorEntry("Color",
                                              &colorGroup().button()));
    fgBtn->setColor(config->readColorEntry("TextColor",
                                           &colorGroup().text()));

    opacitySlider->setValue(config->readNumEntry("Opacity", 10));
    shadowBtn->setChecked(config->readBoolEntry("ShadowText", true));
    emit changed(false);
}

void TransMenuConfig::defaults()
{
    load();
    emit changed(true);
}

void TransMenuConfig::slotBtnGroupClicked(int id)
{
    editGroup->setEnabled(id == Custom);
    emit changed(true);
}

void TransMenuConfig::slotShadowBtnClicked()
{
    emit changed(true);
}

TransMenuConfig::TransMenuConfig(QWidget *parent, const char *name)
    : KCModule(parent, name)
{
    QVBoxLayout *layout = new QVBoxLayout(this);
    QLabel *warnLbl = new QLabel(i18n("<B>Warning:</B> for Mosfet styles only!"), this);
    layout->addWidget(warnLbl);
    layout->addSpacing(16);


    btnGroup = new QVButtonGroup(i18n("Menu style"), this);
    (void)new QRadioButton(i18n("No translucency"), btnGroup);
    (void)new QRadioButton(i18n("Stippled, background color"), btnGroup);
    (void)new QRadioButton(i18n("Stippled, button color"), btnGroup);
    (void)new QRadioButton(i18n("Translucent stippled, background color"), btnGroup);
    (void)new QRadioButton(i18n("Translucent stippled, button color"), btnGroup);
    (void)new QRadioButton(i18n("Custom translucency"), btnGroup);
    connect(btnGroup, SIGNAL(clicked(int)), SLOT(slotBtnGroupClicked(int)));
    layout->addWidget(btnGroup);

    editGroup = new QGroupBox(i18n("Translucency editor"), this);
    QGridLayout *editLayout = new QGridLayout(editGroup, 1, 1, 10);
    QLabel *colorLbl = new QLabel(i18n("Menu color:"), editGroup);
    colorBtn =  new KColorButton(editGroup);
    QLabel *fgLbl = new QLabel(i18n("Text color:"), editGroup);
    fgBtn =  new KColorButton(editGroup);

    QLabel *opacityLbl = new QLabel(i18n("Opacity:"), editGroup);
    opacitySlider = new QSlider(0, 20, 1, 10, Qt::Horizontal,
                                editGroup);

    editLayout->addRowSpacing(0, 12);
    editLayout->addWidget(colorLbl, 1, 0);
    editLayout->addWidget(colorBtn, 1, 1);
    editLayout->addWidget(fgLbl, 1, 2);
    editLayout->addWidget(fgBtn, 1, 3);

    editLayout->addMultiCellWidget(opacityLbl, 2, 2, 0, 4);
    editLayout->addMultiCellWidget(opacitySlider, 3, 3, 0, 4);
    editLayout->setColStretch(4, 1);
    editLayout->setRowStretch(4, 1);

    layout->addWidget(editGroup);

    layout->addSpacing(16);
    shadowBtn = new QRadioButton(i18n("Use shadowed text"), this);
    connect(shadowBtn, SIGNAL(clicked()), SLOT(slotShadowBtnClicked()));
    layout->addWidget(shadowBtn);

    layout->addStretch(1);

    load();
    editGroup->setEnabled(btnGroup->id(btnGroup->selected()) == Custom);

}

TransMenuConfig::~TransMenuConfig()
{
    ;
}



#include "transmenu.moc"
















