class glusterfs_client( $clustername = $uniqueid, $mode = "distributed", $mount_point = "/home/export" )
{
  package{"glusterfs-client": ensure => installed} -> File <<| tag == "glusterfs_${clustername}" |>>

  exec{"${clustername}_dir":
    command => "mkdir -p /etc/glusterfs/${clustername}",
    unless => "test -d /etc/glusterfs/${clustername}",
    require => Package["glusterfs-client"],
  }

  # glusterfs.vol header
  file {"glusterfs_vol_header":
    name    => "/etc/glusterfs/glusterfs.vol",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    require => Exec["${clustername}_dir"],
    content => template("/etc/puppet/modules/orchestra-glusterfs/templates/glusterfs.vol.erb"),
  }

  # glusterfs server(s) config
  exec{"update_client_features":
    command => "cat /etc/glusterfs/${clustername}/*.server_config >> /etc/glusterfs/glusterfs.vol",
    require => File["glusterfs_vol_header"],
    onlyif => "test `find /etc/glusterfs/${clustername}/*.server_config | wc -l` -gt 0",
  }

  # define operating mode
  case $mode
  {
    "distributed": {
      exec{"define_servers":
	command => "echo \"volume fsmode\n    type cluster/distribute\n    subvolumes `cat /etc/glusterfs/${clustername}/*.server`\nend-volume\" >> /etc/glusterfs/glusterfs.vol",
	require => Exec["update_client_features"],
      }
    }
    "raid0": {
      exec{"define_servers":
	command => "echo \"volume fsmode\n    type cluster/stripe\n    subvolumes `cat /etc/glusterfs/${clustername}/*.server`\nend-volume\" >> /etc/glusterfs/glusterfs.vol",
	require => Exec["update_client_features"],
      }
    }
    "raid1": {
    }
  }

  # glusterfs.vol footer
  file {"glusterfs_vol_footer":
    name    => "/etc/glusterfs/glusterfs.vol.footer",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    require => Exec["define_servers"],
    content => template("/etc/puppet/modules/orchestra-glusterfs/templates/client_features.erb"),
  }

  # Append the footer to glusterfs.vol
  exec{"update_glusterfs_vol_footer":
    command => "cat /etc/glusterfs/glusterfs.vol.footer >> /etc/glusterfs/glusterfs.vol",
    require => File["glusterfs_vol_footer"],
    notify => Mount["${mount_point}"],
  }

  exec{"create_${mount_point}":
    command => "mkdir -p ${mount_point}",
    require => Exec["update_glusterfs_vol_footer"],
    unless => "test -d ${mount_point}"
  }

  # mount the filesystem
  mount{"${mount_point}":
    device => "/etc/glusterfs/glusterfs.vol",
    ensure => mounted,
    fstype => "glusterfs",
    require => Exec["create_${mount_point}"],
    options => "defaults,_netdev",
    remounts => false,
    subscribe => Exec["update_glusterfs_vol_footer"],
  }

} 
