class mongodb_replicaset ( 
  $deploymentname = $uniqueid, 
  $dbhost = $ipaddress_eth0, 
  $dbport = '27017', 
  $dbdatadir = '/var/lib/mongodb/data') 
{
  include mongodb

  exec{ "create_${deploymentname}_dir":
    command => "mkdir -p /etc/mongodb/deployments/${deploymentname}",
    unless => "test -d /etc/mongodb/deployments/${deploymentname}",
  } -> File <<| tag == "mongodb_${deploymentname}" |>> { ensure => present, require => Exec["create_${deploymentname}_dir"] }

#   @@file{ "/etc/mongodb/deployments/${deploymentname}/${uniqueid}.replica_set.deployment_data": 
#     content => "${dbhost}:${dbport}", 
#     tag => "${deploymentname}", 
#     ensure => present,
#     require => Exec["create_${deploymentname}_dir"],
#   } 

  package{"mongodb-stable": 
    alias => "mongodb",
    ensure => installed,
    require => [ Apt::Source["mongodb"], Exec["apt_update"] ],
  }

  file {"mongodb_config":
    name    => "/etc/mongodb.conf",
    ensure  => present,
    owner   => "root",
    group   => "root",
    mode    => "644",
    require => Package["mongodb"],
  }

  service {"mongodb":
    ensure => running,
    enable => true,
    subscribe => File["mongodb_config"],
    hasstatus => true,
    require => Package["mongodb"],
  }

  exec{ "update_mongo_upstart": 
    command => "/bin/sed -i /etc/init/mongodb.conf -e 's/-- --config/-- --replSet ${deploymentname} --config/'", 
    unless => "grep replSet /etc/init/mongodb.conf", 
    require => Package["mongodb"],
    notify => Service["mongodb"],
  }

  exec{"join_replicaset":
    command => "/usr/bin/mongo `cat /etc/mongodb/deployments/${deploymentname}/dbhost.deployment_data`/admin --eval 'rs.add(${ipaddress_eth0})'",
    require => Exec["update_mongo_upstart"],
  }

} 
