class tomcat6( $clustername = $uniqueid, $admin_username = "admin", $admin_password = "admin", $listen_port = "8080", $enable_ajp = false )
{
  package{"tomcat6": ensure => installed}
  package{"tomcat6-admin": ensure => installed}
  package{"tomcat6-docs": ensure => installed}
  package{"tomcat6-examples": ensure => installed}

  exec{"${clustername}_dir":
    command => "mkdir -p /etc/tomcat6/${clustername}",
    require => Package["tomcat6"],
  } -> File <<| tag == "tomcat6_${clustername}" |>>

  @@file{"${uniqueid}_static_members":
    name => "/etc/tomcat6/${clustername}/${uniqueid}.static_member",
    content => template("/etc/puppet/modules/orchestra-tomcat/templates/static_members.erb"),
    ensure => present,
    owner => "root",
    group => "tomcat6",
    mode => "640",
    tag => "tomcat6_${clustername}",
    require => Exec["${clustername}_dir"],
  }

  file {"tomcat_users":
    name    => "/etc/tomcat6/tomcat-users.xml",
    content => template("/etc/puppet/modules/orchestra-tomcat/templates/tomcat-users.xml.erb"),
    ensure  => present,
    owner   => "root",
    group   => "tomcat6",
    mode    => "640",
    require => Package["tomcat6"],
  }

  file {"server_xml_top":
    name => "/etc/tomcat6/${clustername}/server.xml.top",
    content => template("/etc/puppet/modules/orchestra-tomcat/templates/server_xml_1.erb"),
    ensure => present,
    owner => "root",
    group => "tomcat6",
    mode => "640",
    require => Exec["${clustername}_dir"],
  }

  exec{"static_members":
    command => "cat /etc/tomcat6/${clustername}/*.static_member > /etc/tomcat6/${clustername}/${clustername}.static_members",
    require => Exec["${clustername}_dir"],
  }

  file {"server_xml_bottom":
    name => "/etc/tomcat6/${clustername}/server.xml.bottom",
    content => template("/etc/puppet/modules/orchestra-tomcat/templates/server_xml_2.erb"),
    ensure => present,
    owner => "root",
    group => "tomcat6",
    mode => "640",
    require => Exec["${clustername}_dir"],
  }

  exec{"create_server_xml":
    command => "cat /etc/tomcat6/${clustername}/server.xml.top > /etc/tomcat6/server.xml",
    require => File["server_xml_top"],
  }

  exec{"update_static_members":
    command => "cat /etc/tomcat6/${clustername}/${clustername}.static_members >> /etc/tomcat6/server.xml",
    require => Exec["static_members", "create_server_xml"],
  }

  exec{"finish_server_xml":
    command => "cat /etc/tomcat6/${clustername}/server.xml.bottom >> /etc/tomcat6/server.xml",
    require => [ File["server_xml_bottom"], Exec["create_server_xml", "update_static_members"] ],
    notify => Service["tomcat6"],
  }

  file{"server_xml":
    name => "/etc/tomcat6/server.xml",
    owner => "root",
    group => "tomcat6",
    mode => "640",
    require => Exec["create_server_xml", "update_static_members", "finish_server_xml"],
  }

  service {"tomcat6":
    ensure => running,
    enable => true,
    subscribe => File["tomcat_users", "server_xml"],
    hasstatus => true,
    require => Package["tomcat6"],
  }

  # If not working with Apache/AJP, export the loadbalancer configuration
  if ( $enable_ajp == false )
  {
    @@file{"/etc/haproxy/${clustername}/tomcat.${uniqueid}.server":
      ensure => present,
      content => template("/etc/puppet/modules/orchestra-tomcat/templates/tomcat_haproxy.erb"),
      tag => "loadbalancer_${clustername}",
    }
  }

  # Install and configure Apache/AJP to work with Tomcat
  if ( $enable_ajp == true )
  {
    package{ "libapache2-mod-jk": ensure => installed }

    file {"apache_tomcat_config":
      name => "/etc/apache2/conf.d/apache_tomcat.conf",
      content => template("/etc/puppet/modules/orchestra-tomcat/templates/apache_tomcat.conf.erb"),
      ensure => present,
      owner => "root",
      group => "root",
      mode => "644",
      require => Package["libapache2-mod-jk"],
    }

    service {"apache2":
      ensure => running,
      enable => true,
      subscribe => File["apache_tomcat_config"],
      hasstatus => true,
      restart => "/etc/init.d/apache2 reload",
      require => Package["libapache2-mod-jk"],
    }

    exec{"disable_default_site":
      command => "a2dissite default",
      notify => Service["apache2"],
      require => Package["libapache2-mod-jk"],
    }

    file{"apache_tomcat_site":
      name => "/etc/apache2/sites-available/apache_tomcat",
      content => template("/etc/puppet/modules/orchestra-tomcat/templates/apache_tomcat_site.erb"),
      ensure => present,
      owner => "root",
      group => "root",
      mode => "644",
      require => Package["libapache2-mod-jk"],
      notify => Service["apache2"],
    }

    exec{"enable_apache_tomcat_site":
      command => "a2ensite apache_tomcat",
      require => File["apache_tomcat_site"],
    }

    exec{"jsp_example":
      command => "cp /usr/share/tomcat6-examples/examples/jsp/jsp2/el/basic-arithmetic.jsp /var/lib/tomcat6/webapps/ROOT/example.jsp",
      require => Package["tomcat6", "tomcat6-examples", "libapache2-mod-jk"],
    }

    @@file{"/etc/haproxy/${clustername}/apache_tomcat.${uniqueid}.server":
      ensure => present,
      content => template("/etc/puppet/modules/orchestra-tomcat/templates/haproxy.erb"),
      tag => "loadbalancer_${clustername}",
    }


  }


} 
