/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.Serializable;
import java.util.HashMap;
import org.javagroups.ChannelException;
import org.javagroups.blocks.LockManager;
import org.javagroups.blocks.LockNotGrantedException;
import org.javagroups.blocks.LockNotReleasedException;
import org.javagroups.blocks.TwoPhaseVotingAdapter;
import org.javagroups.blocks.TwoPhaseVotingListener;
import org.javagroups.blocks.VoteException;
import org.javagroups.blocks.VotingAdapter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DistributedLockManager
implements TwoPhaseVotingListener,
LockManager {
    private static long ACQUIRE_EXPIRATION = 5000L;
    private static long VOTE_TIMEOUT = 10000L;
    private HashMap preparedLocks;
    private HashMap preparedReleases;
    private HashMap heldLocks;
    private TwoPhaseVotingAdapter votingAdapter;
    private Object id;

    private final boolean localLock(LockDecree lockDecree) {
        this.removeExpired(lockDecree);
        LockDecree localLock = (LockDecree)this.heldLocks.get(lockDecree.getKey());
        if (localLock == null) {
            lockDecree.commit();
            if (lockDecree.managerId.equals(this.id)) {
                this.heldLocks.put(lockDecree.getKey(), lockDecree);
            }
            return true;
        }
        return localLock.requester.equals(lockDecree.requester);
    }

    private final boolean canLock(LockDecree decree) {
        this.removeExpired(decree);
        LockDecree lock = (LockDecree)this.heldLocks.get(decree.getKey());
        if (lock == null) {
            return true;
        }
        return lock.requester.equals(decree.requester);
    }

    private final boolean canRelease(LockDecree decree) {
        this.removeExpired(decree);
        LockDecree lock = (LockDecree)this.heldLocks.get(decree.getKey());
        if (lock == null) {
            return true;
        }
        return lock.requester.equals(decree.requester);
    }

    private final void removeExpired(LockDecree decree) {
        LockDecree localLock = (LockDecree)this.heldLocks.get(decree.getKey());
        if (localLock != null && !localLock.isValid()) {
            this.heldLocks.remove(localLock.getKey());
        }
    }

    private final boolean localRelease(LockDecree lockDecree) {
        this.removeExpired(lockDecree);
        LockDecree localLock = (LockDecree)this.heldLocks.get(lockDecree.getKey());
        if (localLock == null) {
            return true;
        }
        if (localLock.requester.equals(lockDecree.requester)) {
            this.heldLocks.remove(lockDecree.getKey());
            return true;
        }
        return false;
    }

    public void lock(Object lockId, Object owner, int timeout) throws LockNotGrantedException, ChannelException {
        if (!(lockId instanceof Serializable) || !(owner instanceof Serializable)) {
            throw new ClassCastException("DistributedLockManager works only with serializable objects.");
        }
        boolean acquired = this.votingAdapter.vote(new AcquireLockDecree(lockId, owner, this.id), timeout);
        if (!acquired) {
            throw new LockNotGrantedException("Lock cannot be granted.");
        }
    }

    public void unlock(Object lockId, Object owner) throws LockNotReleasedException, ChannelException {
        if (!(lockId instanceof Serializable) || !(owner instanceof Serializable)) {
            throw new ClassCastException("DistributedLockManager works only with serializable objects.");
        }
        boolean released = this.votingAdapter.vote(new ReleaseLockDecree(lockId, owner, this.id), VOTE_TIMEOUT);
        if (!released) {
            throw new LockNotReleasedException("Lock cannot be unlocked.");
        }
    }

    private final boolean checkPrepared(HashMap preparedContainer, LockDecree requestedDecree) {
        LockDecree preparedDecree = (LockDecree)preparedContainer.get(requestedDecree.getKey());
        if (preparedDecree != null && !preparedDecree.isValid()) {
            preparedContainer.remove(preparedDecree.getKey());
            preparedDecree = null;
        }
        if (preparedDecree != null) {
            return requestedDecree.requester.equals(preparedDecree.requester);
        }
        return true;
    }

    public synchronized boolean prepare(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            AcquireLockDecree acquireDecree = (AcquireLockDecree)decree;
            if (!this.checkPrepared(this.preparedLocks, acquireDecree)) {
                return false;
            }
            if (this.canLock(acquireDecree)) {
                this.preparedLocks.put(acquireDecree.getKey(), acquireDecree);
                return true;
            }
            return false;
        }
        if (decree instanceof ReleaseLockDecree) {
            ReleaseLockDecree releaseDecree = (ReleaseLockDecree)decree;
            if (!this.checkPrepared(this.preparedReleases, releaseDecree)) {
                return false;
            }
            if (this.canRelease(releaseDecree)) {
                this.preparedReleases.put(releaseDecree.getKey(), releaseDecree);
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized boolean commit(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            if (!this.checkPrepared(this.preparedLocks, (LockDecree)decree)) {
                return false;
            }
            if (this.localLock((LockDecree)decree)) {
                this.preparedLocks.remove(((LockDecree)decree).getKey());
                return true;
            }
            return false;
        }
        if (decree instanceof ReleaseLockDecree) {
            if (!this.checkPrepared(this.preparedReleases, (LockDecree)decree)) {
                return false;
            }
            if (this.localRelease((LockDecree)decree)) {
                this.preparedReleases.remove(((LockDecree)decree).getKey());
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized void abort(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            if (!this.checkPrepared(this.preparedLocks, (LockDecree)decree)) {
                return;
            }
            this.preparedLocks.remove(((LockDecree)decree).getKey());
        } else if (decree instanceof ReleaseLockDecree) {
            if (!this.checkPrepared(this.preparedReleases, (LockDecree)decree)) {
                return;
            }
            this.preparedReleases.remove(((LockDecree)decree).getKey());
        }
    }

    private final /* synthetic */ void this() {
        this.preparedLocks = new HashMap();
        this.preparedReleases = new HashMap();
        this.heldLocks = new HashMap();
    }

    public DistributedLockManager(VotingAdapter voteChannel, Object id) {
        this(new TwoPhaseVotingAdapter(voteChannel), id);
    }

    public DistributedLockManager(TwoPhaseVotingAdapter channel, Object id) {
        this.this();
        this.id = id;
        this.votingAdapter = channel;
        this.votingAdapter.addListener(this);
    }

    public static class LockDecree
    implements Serializable {
        protected Object lockId;
        protected Object requester;
        protected Object managerId;
        protected boolean commited;

        public Object getKey() {
            return this.lockId;
        }

        public boolean isValid() {
            return true;
        }

        public void commit() {
            this.commited = true;
        }

        public int hashCode() {
            return this.lockId.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof LockDecree) {
                return ((LockDecree)other).lockId.equals(this.lockId);
            }
            return false;
        }

        private LockDecree(Object lockId, Object requester, Object managerId) {
            this.lockId = lockId;
            this.requester = requester;
            this.managerId = managerId;
        }
    }

    public static class AcquireLockDecree
    extends LockDecree {
        private long creationTime = System.currentTimeMillis();

        public boolean isValid() {
            boolean result = super.isValid();
            if (!this.commited && result) {
                boolean bl = false;
                if (this.creationTime + ACQUIRE_EXPIRATION > System.currentTimeMillis()) {
                    bl = true;
                }
                result = bl;
            }
            return result;
        }

        private AcquireLockDecree(LockDecree lockDecree) {
            this(lockDecree.lockId, lockDecree.requester, lockDecree.managerId);
        }

        private AcquireLockDecree(Object lockId, Object requester, Object managerId) {
            super(lockId, requester, managerId);
        }
    }

    public static class ReleaseLockDecree
    extends LockDecree {
        ReleaseLockDecree(Object lockId, Object requester, Object managerId) {
            super(lockId, requester, managerId);
        }
    }
}

