/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Vector;
import org.javagroups.blocks.Link;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogicalLink
implements Link.Receiver {
    Receiver receiver;
    Vector links;
    int link_to_use;

    public void addLink(String local_addr, int local_port, String remote_addr, int remote_port) {
        Link new_link = new Link(local_addr, local_port, remote_addr, remote_port, this);
        if (this.links.contains(new_link)) {
            System.err.println("LogicalLink.add(): link " + new_link + " is already present");
        } else {
            this.links.addElement(new_link);
        }
    }

    public void addLink(String local_addr, int local_port, String remote_addr, int remote_port, long timeout, long hb_interval) {
        Link new_link = new Link(local_addr, local_port, remote_addr, remote_port, timeout, hb_interval, this);
        if (this.links.contains(new_link)) {
            System.err.println("LogicalLink.add(): link " + new_link + " is already present");
        } else {
            this.links.addElement(new_link);
        }
    }

    public void removeAllLinks() {
        int i = 0;
        while (i < this.links.size()) {
            Link tmp = (Link)this.links.elementAt(i);
            tmp.stop();
            ++i;
        }
        this.links.removeAllElements();
    }

    public Vector getLinks() {
        return this.links;
    }

    public int numberOfLinks() {
        return this.links.size();
    }

    public int numberOfEstablishedLinks() {
        int n = 0;
        int i = 0;
        while (i < this.links.size()) {
            if (((Link)this.links.elementAt(i)).established()) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public void start() {
        int i = 0;
        while (i < this.links.size()) {
            Link tmp = (Link)this.links.elementAt(i);
            try {
                tmp.start();
            }
            catch (Exception ex) {
                System.err.println("LogicalLink.start(): could not create physical link, reason: " + ex);
            }
            ++i;
        }
    }

    public void stop() {
        int i = 0;
        while (i < this.links.size()) {
            Link tmp = (Link)this.links.elementAt(i);
            tmp.stop();
            ++i;
        }
    }

    public boolean send(byte[] buf) throws AllLinksDown, NoLinksAvailable {
        int link_used = 0;
        if (buf == null || buf.length == 0) {
            System.err.println("LogicalLink.send(): buf is null or empty");
            return false;
        }
        if (this.links.size() == 0) {
            throw new NoLinksAvailable();
        }
        int i = 0;
        while (i < this.links.size()) {
            Link link = (Link)this.links.elementAt(i);
            if (link.established() && link.send(buf)) {
                System.out.println("Send over link #" + link_used + ": " + link);
                return true;
            }
            ++i;
        }
        throw new AllLinksDown();
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public synchronized void receive(byte[] buf) {
        if (this.receiver != null) {
            this.receiver.receive(buf);
        }
    }

    public synchronized void linkDown(InetAddress local, int local_port, InetAddress remote, int remote_port) {
        if (this.receiver != null) {
            this.receiver.linkDown(local, local_port, remote, remote_port);
        }
    }

    public synchronized void linkUp(InetAddress local, int local_port, InetAddress remote, int remote_port) {
        if (this.receiver != null) {
            this.receiver.linkUp(local, local_port, remote, remote_port);
        }
    }

    public synchronized void missedHeartbeat(InetAddress local, int local_port, InetAddress remote, int remote_port, int num_missed_hbs) {
        if (this.receiver != null) {
            this.receiver.missedHeartbeat(local, local_port, remote, remote_port, num_missed_hbs);
        }
    }

    public synchronized void receivedHeartbeatAgain(InetAddress local, int local_port, InetAddress remote, int remote_port) {
        if (this.receiver != null) {
            this.receiver.receivedHeartbeatAgain(local, local_port, remote, remote_port);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        ll = new LogicalLink();
        i = 0;
        ll.setReceiver(new MyReceiver());
        if (args.length % 4 == 0 && args.length != 0) ** GOTO lbl12
        System.err.println("\nLogicalLink <link+>\nwhere <link> is <local host> <local port> <remote host> <remote port>\n");
        return;
lbl-1000:
        // 1 sources

        {
            local_host = args[i++];
            local_port = new Integer(args[i++]);
            remote_host = args[i++];
            remote_port = new Integer(args[i++]);
            ll.addLink(local_host, local_port, remote_host, remote_port);
lbl12:
            // 2 sources

            ** while (i < args.length)
        }
lbl13:
        // 1 sources

        try {
            ll.start();
        }
        catch (Exception e) {
            System.err.println("LogicalLink.main(): " + e);
        }
        in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                System.out.print("> ");
                System.out.flush();
                line = in.readLine();
                ll.send(line.getBytes());
                continue;
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }

    private final /* synthetic */ void this() {
        this.receiver = null;
        this.links = new Vector();
        this.link_to_use = 0;
    }

    public LogicalLink(Receiver r) {
        this.this();
        this.receiver = r;
    }

    public LogicalLink() {
        this.this();
    }

    public class NoLinksAvailable
    extends Exception {
        public String toString() {
            return "LogicalLinks.NoLinksAvailable: there are no physical links available";
        }
    }

    public class AllLinksDown
    extends Exception {
        public String toString() {
            return "LogicalLinks.AllLinksDown: all physical links are currently down";
        }
    }

    private static class MyReceiver
    implements Receiver {
        public void receive(byte[] buf) {
            System.out.println("<-- " + new String(buf));
        }

        public synchronized void linkDown(InetAddress l, int lp, InetAddress r, int rp) {
            System.out.println("** linkDown(): " + r + ':' + rp);
        }

        public synchronized void linkUp(InetAddress l, int lp, InetAddress r, int rp) {
            System.out.println("** linkUp(): " + r + ':' + rp);
        }

        public synchronized void missedHeartbeat(InetAddress l, int lp, InetAddress r, int rp, int num) {
        }

        public synchronized void receivedHeartbeatAgain(InetAddress l, int lp, InetAddress r, int rp) {
        }

        private MyReceiver() {
        }
    }

    public static interface Receiver {
        public void receive(byte[] var1);

        public void linkDown(InetAddress var1, int var2, InetAddress var3, int var4);

        public void linkUp(InetAddress var1, int var2, InetAddress var3, int var4);

        public void missedHeartbeat(InetAddress var1, int var2, InetAddress var3, int var4, int var5);

        public void receivedHeartbeatAgain(InetAddress var1, int var2, InetAddress var3, int var4);
    }
}

