/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.TimeoutException;
import org.javagroups.blocks.LockingException;
import org.javagroups.blocks.ReplicationManager;
import org.javagroups.blocks.ReplicationReceiver;
import org.javagroups.blocks.TransactionalHashtable;
import org.javagroups.blocks.UpdateException;
import org.javagroups.blocks.Xid;
import org.javagroups.log.Trace;
import org.javagroups.util.RWLock;
import org.javagroups.util.Rsp;
import org.javagroups.util.RspList;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TransactionalHashtable
extends HashMap
implements ReplicationReceiver,
MessageListener {
    private static ThreadLocal thread_local = new 1();
    protected ReplicationManager repl_mgr;
    protected Channel channel;
    protected Address local_addr;
    protected String groupname;
    protected String properties;
    protected long state_timeout;
    protected boolean default_sync_repl;
    protected long default_sync_repl_timeout;
    protected long lock_acquisition_timeout;
    protected long lock_lease_timeout;
    protected int transaction_mode;
    protected RWLock table_lock;
    protected HashMap row_locks;
    protected boolean auto_commit;
    protected List notifs;

    public void addNotifier(Notification n) {
        if (!this.notifs.contains(n)) {
            this.notifs.add(n);
        }
    }

    public Object get(Object key) {
        return super.get(key);
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    public Object put(Object key, Object value) {
        return this.put(key, value, this.default_sync_repl, this.default_sync_repl_timeout);
    }

    public Object put(Object key, Object value, boolean synchronous, long timeout) {
        byte[] buf;
        Data data = new Data(1, (Serializable)key, (Serializable)value);
        try {
            buf = Util.objectToByteBuffer(data);
        }
        catch (Throwable ex) {
            Trace.error("TransactionalHashtable.put()", "marshalling failure: " + ex);
            return null;
        }
        Object retval = this.get(key);
        this.repl_mgr.send(null, buf, synchronous, timeout, null, null, 0L, 0L, false);
        return retval;
    }

    public Object put(Object key, Object value, long sync_timeout, long lock_acquisition_timeout, long lock_lease_timeout, boolean commit) throws LockingException, TimeoutException {
        RspList rsps;
        byte[] buf;
        Data data = new Data(1, (Serializable)key, (Serializable)value);
        try {
            buf = Util.objectToByteBuffer(data);
        }
        catch (Throwable ex) {
            Trace.error("TransactionalHashtable.put()", "marshalling failure: " + ex);
            return null;
        }
        Object retval = this.get(key);
        Xid curr_transaction = TransactionalHashtable.getCurrentTransaction();
        if (curr_transaction == null) {
            Trace.info("TransactionalHashtable.putl()", "no transaction associated with current thread. Will create new transaction with transaction mode=" + Xid.modeToString(this.transaction_mode));
            try {
                this.begin(this.transaction_mode);
            }
            catch (Throwable ex) {
                Trace.error("TransactionalHashtable.putl()", "could not start new transaction: " + ex);
                return null;
            }
            curr_transaction = TransactionalHashtable.getCurrentTransaction();
        }
        if ((rsps = this.repl_mgr.send(null, buf, true, sync_timeout, curr_transaction, null, lock_acquisition_timeout, lock_lease_timeout, true)) == null) {
            Trace.error("TransactionalHashtable.putl()", "RspList of call is null");
        } else {
            this.checkResults(rsps);
        }
        if (commit) {
            this.commit(TransactionalHashtable.getCurrentTransaction());
        }
        return retval;
    }

    public Object lput(Object key, Object value) throws LockingException, TimeoutException {
        return this.put(key, value, this.default_sync_repl_timeout, this.lock_acquisition_timeout, this.lock_lease_timeout, this.auto_commit);
    }

    public void putAll(Map m) {
        this.putAll(m, this.default_sync_repl, this.default_sync_repl_timeout);
    }

    public void putAll(Map m, boolean synchronous, long timeout) {
        byte[] buf;
        Data data = new Data(2, m);
        try {
            buf = Util.objectToByteBuffer(data);
        }
        catch (Throwable ex) {
            Trace.error("TransactionalHashtable.putAll()", "marshalling failure: " + ex);
            return;
        }
        this.repl_mgr.send(null, buf, synchronous, timeout, null, null, 0L, 0L, false);
    }

    public void putAll(Map m, long sync_timeout, long lock_acquisition_timeout, long lock_lease_timeout, boolean commit) throws LockingException, TimeoutException {
        RspList rsps;
        byte[] buf;
        Data data = new Data(2, (Serializable)((Object)m));
        try {
            buf = Util.objectToByteBuffer(data);
        }
        catch (Throwable ex) {
            Trace.error("TransactionalHashtable.putAll()", "marshalling failure: " + ex);
            return;
        }
        Xid curr_transaction = TransactionalHashtable.getCurrentTransaction();
        if (curr_transaction == null) {
            Trace.info("TransactionalHashtable.putAlll()", "no transaction associated with current thread. Will create new transaction with transaction mode=" + Xid.modeToString(this.transaction_mode));
            try {
                this.begin(this.transaction_mode);
            }
            catch (Throwable ex) {
                Trace.error("TransactionalHashtable.putAll()", "could not start new transaction: " + ex);
                return;
            }
            curr_transaction = TransactionalHashtable.getCurrentTransaction();
        }
        if ((rsps = this.repl_mgr.send(null, buf, true, sync_timeout, curr_transaction, null, lock_acquisition_timeout, lock_lease_timeout, true)) == null) {
            Trace.error("TransactionalHashtable.putAlll()", "RspList of call is null");
        } else {
            this.checkResults(rsps);
        }
        if (commit) {
            this.commit(TransactionalHashtable.getCurrentTransaction());
        }
    }

    public void lputAll(Map m) throws LockingException, TimeoutException {
        this.putAll(m, this.default_sync_repl_timeout, this.lock_acquisition_timeout, this.lock_lease_timeout, this.auto_commit);
    }

    public Object remove(Object key) {
        return this.remove(key, this.default_sync_repl, this.default_sync_repl_timeout);
    }

    public Object remove(Object key, boolean synchronous, long timeout) {
        byte[] buf;
        Data data = new Data(3, (Serializable)key);
        try {
            buf = Util.objectToByteBuffer(data);
        }
        catch (Throwable ex) {
            Trace.error("TransactionalHashtable.remove()", "marshalling failure: " + ex);
            return null;
        }
        Object retval = this.get(key);
        this.repl_mgr.send(null, buf, synchronous, timeout, null, null, 0L, 0L, false);
        return retval;
    }

    public Object remove(Object key, long sync_timeout, long lock_acquisition_timeout, long lock_lease_timeout, boolean commit) throws LockingException, TimeoutException {
        RspList rsps;
        byte[] buf;
        Data data = new Data(3, (Serializable)key);
        try {
            buf = Util.objectToByteBuffer(data);
        }
        catch (Throwable ex) {
            Trace.error("TransactionalHashtable.remove()", "marshalling failure: " + ex);
            return null;
        }
        Object retval = this.get(key);
        Xid curr_transaction = TransactionalHashtable.getCurrentTransaction();
        if (curr_transaction == null) {
            Trace.info("TransactionalHashtable.removel()", "no transaction associated with current thread. Will create new transaction with transaction mode=" + Xid.modeToString(this.transaction_mode));
            try {
                this.begin(this.transaction_mode);
            }
            catch (Throwable ex) {
                Trace.error("TransactionalHashtable.remove()", "could not start new transaction: " + ex);
                return null;
            }
            curr_transaction = TransactionalHashtable.getCurrentTransaction();
        }
        if ((rsps = this.repl_mgr.send(null, buf, true, sync_timeout, curr_transaction, null, lock_acquisition_timeout, lock_lease_timeout, true)) == null) {
            Trace.error("TransactionalHashtable.removel()", "RspList of call is null");
        } else {
            this.checkResults(rsps);
        }
        if (commit) {
            this.commit(TransactionalHashtable.getCurrentTransaction());
        }
        return retval;
    }

    public Object lremove(Object key, Object value) throws LockingException, TimeoutException {
        return this.remove(key, this.default_sync_repl_timeout, this.lock_acquisition_timeout, this.lock_lease_timeout, this.auto_commit);
    }

    public void clear() {
        this.clear(this.default_sync_repl, this.default_sync_repl_timeout);
    }

    public void clear(boolean synchronous, long timeout) {
        byte[] buf;
        Data data = new Data(4);
        try {
            buf = Util.objectToByteBuffer(data);
        }
        catch (Throwable ex) {
            Trace.error("TransactionalHashtable.clear()", "marshalling failure: " + ex);
            return;
        }
        this.repl_mgr.send(null, buf, synchronous, timeout, null, null, 0L, 0L, false);
    }

    public void clear(long sync_timeout, long lock_acquisition_timeout, long lock_lease_timeout, boolean commit) throws LockingException, TimeoutException {
        RspList rsps;
        byte[] buf;
        Data data = new Data(4);
        try {
            buf = Util.objectToByteBuffer(data);
        }
        catch (Throwable ex) {
            Trace.error("TransactionalHashtable.clear()", "marshalling failure: " + ex);
            return;
        }
        Xid curr_transaction = TransactionalHashtable.getCurrentTransaction();
        if (curr_transaction == null) {
            Trace.info("TransactionalHashtable.clearl()", "no transaction associated with current thread. Will create new transaction with transaction mode=" + Xid.modeToString(this.transaction_mode));
            try {
                this.begin(this.transaction_mode);
            }
            catch (Throwable ex) {
                Trace.error("TransactionalHashtable.clear()", "could not start new transaction: " + ex);
                return;
            }
            curr_transaction = TransactionalHashtable.getCurrentTransaction();
        }
        if ((rsps = this.repl_mgr.send(null, buf, true, sync_timeout, curr_transaction, null, lock_acquisition_timeout, lock_lease_timeout, true)) == null) {
            Trace.error("TransactionalHashtable.clearl()", "RspList of call is null");
        } else {
            this.checkResults(rsps);
        }
        if (commit) {
            this.commit(TransactionalHashtable.getCurrentTransaction());
        }
    }

    public void lclear() throws LockingException, TimeoutException {
        this.clear(this.default_sync_repl_timeout, this.lock_acquisition_timeout, this.lock_lease_timeout, this.auto_commit);
    }

    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public Object clone() {
        return super.clone();
    }

    public Set keySet() {
        return super.keySet();
    }

    public Collection values() {
        return super.values();
    }

    public Set entrySet() {
        return super.entrySet();
    }

    public Object receive(Xid transaction, byte[] buf, byte[] lock_info, long lock_acquisition_timeout, long lock_lease_timeout, boolean use_locks) throws LockingException, UpdateException {
        try {
            Data data = (Data)Util.objectFromByteBuffer(buf);
            switch (data.getRequestType()) {
                case 1: {
                    return this.handlePut(data.getKey(), data.getValue(), transaction, lock_acquisition_timeout, lock_lease_timeout, use_locks);
                }
                case 2: {
                    return this.handlePutAll(data.getMap(), transaction, lock_acquisition_timeout, lock_lease_timeout, use_locks);
                }
                case 3: {
                    return this.handleRemove(data.getKey(), transaction, lock_acquisition_timeout, lock_lease_timeout, use_locks);
                }
                case 4: {
                    return this.handleClear(transaction, lock_acquisition_timeout, lock_lease_timeout, use_locks);
                }
            }
            throw new Exception("request type " + data.getRequestType() + " not known");
        }
        catch (Throwable t) {
            Trace.error("TransactionalHashtable.receive()", "exception is " + t);
            return t;
        }
    }

    public void commit(Xid transaction) {
    }

    public void rollback(Xid transaction) {
    }

    public void receive(Message msg) {
    }

    public byte[] getState() {
        HashMap copy = new HashMap();
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            copy.put(entry.getKey(), entry.getValue());
        }
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (Throwable ex) {
            Trace.error("TransactionalHashtable.getState()", "exception marshalling state: " + ex);
            return null;
        }
    }

    public void setState(byte[] state) {
        HashMap new_copy;
        try {
            new_copy = (HashMap)Util.objectFromByteBuffer(state);
            if (new_copy == null) {
                return;
            }
        }
        catch (Throwable ex) {
            Trace.error("TransactionalHashtable.setState()", "exception unmarshalling state: " + ex);
            return;
        }
        super.clear();
        Iterator it = new_copy.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            super.put(entry.getKey(), entry.getValue());
        }
        if (Trace.trace) {
            Trace.info("TransactionalHashtable.setState()", "hashmap has " + this.size() + " items");
        }
    }

    public void stop() {
        if (this.repl_mgr != null) {
            this.repl_mgr.stop();
        }
    }

    public void setMembershipListener(MembershipListener ml) {
        if (ml == null) {
            return;
        }
        if (this.repl_mgr == null) {
            Trace.error("TransactionalHashtable.setMembershipListener()", "ReplicationManager is null");
        } else {
            this.repl_mgr.setMembershipListener(ml);
        }
    }

    public boolean isDefaultSyncRepl() {
        return this.default_sync_repl;
    }

    public void setDefaultSyncRepl(boolean b) {
        this.default_sync_repl = b;
    }

    public long getDefaultSyncReplTimeout() {
        return this.default_sync_repl_timeout;
    }

    public void setDefaultSyncReplTimeout(long timeout) {
        this.default_sync_repl_timeout = timeout;
    }

    public boolean getAutoCommit() {
        return this.auto_commit;
    }

    public void setAutoCommit(boolean b) {
        this.auto_commit = b;
    }

    public long getLockAcquisitionTimeout() {
        return this.lock_acquisition_timeout;
    }

    public void setLockAcquisitionTimeout(long l) {
        this.lock_acquisition_timeout = l;
    }

    public long getLockLeaseTimeout() {
        return this.lock_lease_timeout;
    }

    public void setLockLeaseTimeout(long l) {
        this.lock_lease_timeout = l;
    }

    public int getTransactionMode() {
        return this.transaction_mode;
    }

    public void setTransactionMode(int m) {
        this.transaction_mode = m;
    }

    public void begin() throws Exception {
        this.begin(1);
    }

    public void begin(int transaction_mode) throws Exception {
        Object m = thread_local.get();
        if (m == null) {
            m = new HashMap();
            thread_local.set(m);
        } else if (!(m instanceof Map)) {
            Trace.warn("ReplicationManager.begin()", "thread local data was not a hashmap (was " + m + "); setting data to be a hashmap");
            m = new HashMap();
            thread_local.set(m);
        }
        Xid xid = (Xid)((Map)m).get("xid");
        if (xid != null) {
            Trace.warn("ReplicationManager.begin()", "transaction already present (will be reused): " + xid);
            return;
        }
        xid = this.repl_mgr.begin(transaction_mode);
        ((Map)m).put("xid", xid);
    }

    public void commit() {
        Xid curr_tx = TransactionalHashtable.getCurrentTransaction();
        if (curr_tx == null) {
            Trace.error("TransactionalHashtable.commit()", "no transaction associated with current thread");
        } else {
            this.repl_mgr.commit(curr_tx);
            ((Map)thread_local.get()).remove("xid");
        }
    }

    public void rollback() {
        Xid curr_tx = TransactionalHashtable.getCurrentTransaction();
        if (curr_tx == null) {
            Trace.error("TransactionalHashtable.rollback()", "no transaction associated with current thread");
        } else {
            this.repl_mgr.rollback(curr_tx);
            ((Map)thread_local.get()).remove("xid");
        }
    }

    public static Xid getCurrentTransaction() {
        Object m = thread_local.get();
        if (m == null || !(m instanceof Map)) {
            return null;
        }
        return (Xid)((Map)m).get("xid");
    }

    protected void initChannel(String groupname, String properties, long state_timeout) throws Exception {
        this.groupname = groupname;
        this.properties = properties;
        this.state_timeout = state_timeout;
        Trace.init();
        this.channel = new JChannel(properties);
        this.channel.setOpt(4, new Boolean(true));
        this.channel.connect(groupname);
        this.repl_mgr = new ReplicationManager(this.channel, this, null, this);
        if (this.channel.getState(null, state_timeout)) {
            Trace.info("TransactionalHashtable.TransactionalHashtable()", "state was retrieved successfully");
        } else {
            Trace.info("TransactionalHashtable.TransactionalHashtable()", "state could not be retrieved (first member)");
        }
    }

    protected Object handlePut(Serializable key, Serializable value, Xid transaction, long lock_acquisition_timeout, long lock_lease_timeout, boolean use_locks) throws LockingException, UpdateException {
        if (Trace.trace) {
            StringBuffer sb = new StringBuffer();
            sb.append("key=").append(key).append(", value=").append(value).append(", use_locks=").append(use_locks);
            if (use_locks) {
                sb.append(", transaction=").append(transaction);
                sb.append(", lock_acquisition_timeout=").append(lock_acquisition_timeout);
                sb.append(", lock_lease_timeout=").append(lock_lease_timeout);
            }
            Trace.info("TransactionalHashtable.handlePut()", sb.toString());
        }
        if (!use_locks) {
            try {
                return super.put(key, value);
            }
            catch (Throwable ex) {
                throw new UpdateException("TransactionalHashtable.handlePut(): exception is " + ex);
            }
        }
        return null;
    }

    protected Object handlePutAll(Map map, Xid transaction, long lock_acquisition_timeout, long lock_lease_timeout, boolean use_locks) throws LockingException, UpdateException {
        return null;
    }

    protected Object handleRemove(Serializable key, Xid transaction, long lock_acquisition_timeout, long lock_lease_timeout, boolean use_locks) throws LockingException, UpdateException {
        return null;
    }

    protected Object handleClear(Xid transaction, long lock_acquisition_timeout, long lock_lease_timeout, boolean use_locks) throws LockingException, UpdateException {
        return null;
    }

    protected void checkResults(RspList rsps) throws LockingException, TimeoutException {
        HashMap<Object, Object> ml = null;
        ArrayList<Object> ll = null;
        LockingException l = null;
        TimeoutException t = null;
        int i = 0;
        while (i < rsps.size()) {
            Rsp rsp = (Rsp)rsps.elementAt(i);
            if (rsp.getValue() != null && rsp.getValue() instanceof Throwable) {
                if (l == null) {
                    ml = new HashMap<Object, Object>();
                    l = new LockingException(ml);
                }
                ml.put(rsp.getSender(), rsp.getValue());
            }
            if (!rsp.wasReceived()) {
                if (t == null) {
                    ll = new ArrayList<Object>();
                    t = new TimeoutException(ll);
                }
                ll.add(rsp.getSender());
            }
            ++i;
        }
        if (l != null) {
            throw l;
        }
        if (t != null) {
            throw t;
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("TransactionalHashtable <key> <val>");
            return;
        }
        try {
            TransactionalHashtable th = new TransactionalHashtable("bla", "file:/home/bela/state_transfer.xml", 3000L);
            System.out.println("-- TransactionalHashtable created");
            System.out.println("-- contents:\n" + TransactionalHashtable.dump(th));
            th.put(args[0], args[1], true, 5000L);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    static String dump(Map m) {
        StringBuffer sb = new StringBuffer();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey()).append(" --> ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    private final /* synthetic */ void this() {
        this.channel = null;
        this.local_addr = null;
        this.groupname = "TransactionalHashtable-Group";
        this.properties = null;
        this.state_timeout = 10000L;
        this.default_sync_repl = false;
        this.default_sync_repl_timeout = 5000L;
        this.lock_acquisition_timeout = 5000L;
        this.lock_lease_timeout = 0L;
        this.transaction_mode = 1;
        this.table_lock = new RWLock();
        this.row_locks = new HashMap();
        this.auto_commit = false;
        this.notifs = new ArrayList();
    }

    public TransactionalHashtable(String groupname, String properties, long state_timeout) throws Exception {
        this.this();
        this.initChannel(groupname, properties, state_timeout);
    }

    public TransactionalHashtable(String groupname, String properties, long state_timeout, Map m) throws Exception {
        super(m);
        this.this();
        this.initChannel(groupname, properties, state_timeout);
        this.putAll(m);
    }

    public TransactionalHashtable(String groupname, String properties, long state_timeout, int initialCapacity) throws Exception {
        super(initialCapacity);
        this.this();
        this.initChannel(groupname, properties, state_timeout);
    }

    public TransactionalHashtable(String groupname, String properties, long state_timeout, int initialCapacity, float loadFactor) throws Exception {
        super(initialCapacity, loadFactor);
        this.this();
        this.initChannel(groupname, properties, state_timeout);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Data
    implements Externalizable {
        public static final int PUT = 1;
        public static final int PUT_ALL = 2;
        public static final int REMOVE = 3;
        public static final int CLEAR = 4;
        int request;
        Serializable key;
        Serializable value;
        Map map;

        public int getRequestType() {
            return this.request;
        }

        public Serializable getKey() {
            return this.key;
        }

        public Serializable getValue() {
            return this.value;
        }

        public Map getMap() {
            return this.map;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.requestToString(this.request));
            switch (this.request) {
                case 1: 
                case 3: {
                    sb.append(" key=").append(this.key).append(", value=").append(this.value);
                    break;
                }
                case 2: {
                    sb.append(" map=").append(this.map.size()).append(" items");
                    break;
                }
                case 4: {
                    break;
                }
            }
            return sb.toString();
        }

        public String requestToString(int r) {
            switch (r) {
                case 1: {
                    return "PUT";
                }
                case 2: {
                    return "PUT_ALL";
                }
                case 3: {
                    return "REMOVE";
                }
                case 4: {
                    return "CLEAR";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.request);
            out.writeObject(this.key);
            out.writeObject(this.value);
            out.writeObject(this.map);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.request = in.readInt();
            this.key = (Serializable)in.readObject();
            this.value = (Serializable)in.readObject();
            this.map = (Map)in.readObject();
        }

        private final /* synthetic */ void this() {
            this.request = 0;
            this.key = null;
            this.value = null;
            this.map = null;
        }

        public Data() {
            this.this();
        }

        public Data(int request_type) {
            this.this();
            this.request = request_type;
        }

        public Data(int request_type, Serializable key, Serializable value) {
            this(request_type);
            this.key = key;
            this.value = value;
        }

        public Data(int request_type, Serializable key) {
            this(request_type);
            this.key = key;
        }

        public Data(int request_type, Map map) {
            this(request_type);
            this.map = map;
        }

        public Data(int request_type, Serializable key, Serializable value, Map map) {
            this(request_type, key, value);
            this.map = map;
        }
    }

    public static interface Notification {
        public void entrySet(Object var1, Object var2);

        public void entryRemoved(Object var1);

        public void viewChange(Vector var1, Vector var2);
    }
}

