/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Marshaller;
import org.javagroups.util.TimeScheduler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FD
extends Protocol {
    Address ping_dest;
    Address local_addr;
    long timeout;
    long last_ack;
    int num_tries;
    int max_tries;
    Vector members;
    Hashtable invalid_pingers;
    Vector pingable_mbrs;
    boolean shun;
    TimeScheduler timer;
    Monitor monitor;
    BroadcastTask bcast_task;

    public String getName() {
        return "FD";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("max_tries")) != null) {
            this.max_tries = new Integer(str);
            props.remove("max_tries");
        }
        if ((str = props.getProperty("shun")) != null) {
            this.shun = new Boolean(str);
            props.remove("shun");
        }
        if (props.size() > 0) {
            System.err.println("FD.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            throw new Exception("FD.init(): timer cannot be retrieved from protocol stack");
        }
        this.timer = this.stack.timer;
    }

    public void stop() {
        if (this.monitor != null) {
            this.monitor.stop();
            this.monitor = null;
        }
    }

    Object getPingDest(Vector mbrs) {
        Object retval = null;
        if (mbrs == null || mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        int i = 0;
        while (i < mbrs.size()) {
            Object tmp = mbrs.elementAt(i);
            if (this.local_addr.equals(tmp)) {
                if (i + 1 >= mbrs.size()) {
                    retval = mbrs.elementAt(0);
                    break;
                }
                retval = mbrs.elementAt(i + 1);
                break;
            }
            ++i;
        }
        return retval;
    }

    void startMonitor() {
        if (this.monitor != null && !this.monitor.started) {
            this.monitor = null;
        }
        if (this.monitor == null) {
            this.monitor = new Monitor();
            this.last_ack = System.currentTimeMillis();
            this.timer.add(this.monitor, true);
            this.num_tries = 0;
        }
    }

    public void up(Event evt) {
        FdHeader hdr = null;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header tmphdr = msg.getHeader(this.getName());
                if (tmphdr == null || !(tmphdr instanceof FdHeader)) {
                    Address sender;
                    if (this.ping_dest == null || (sender = msg.getSrc()) == null || !this.ping_dest.equals(sender)) break;
                    this.last_ack = System.currentTimeMillis();
                    this.num_tries = 0;
                    break;
                }
                hdr = (FdHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 0: {
                        Address hb_sender = msg.getSrc();
                        Message hb_ack = new Message(msg.getSrc(), null, null);
                        FdHeader tmp_hdr = new FdHeader(1);
                        tmp_hdr.from = this.local_addr;
                        hb_ack.putHeader(this.getName(), tmp_hdr);
                        this.passDown(new Event(1, hb_ack));
                        if (!this.shun) break;
                        this.shunInvalidHeartbeatSender(hb_sender);
                        break;
                    }
                    case 1: {
                        if (this.ping_dest != null && this.ping_dest.equals(hdr.from)) {
                            this.last_ack = System.currentTimeMillis();
                            this.num_tries = 0;
                            if (!Trace.trace) break;
                            Trace.info("FD.up()", "received ack from " + hdr.from);
                            break;
                        }
                        this.stop();
                        this.ping_dest = (Address)this.getPingDest(this.members);
                        if (this.ping_dest == null) break;
                        try {
                            this.startMonitor();
                        }
                        catch (Exception ex) {
                            Trace.warn("FD.up()", "exception when calling startMonitor(): " + ex);
                        }
                        break;
                    }
                    case 2: {
                        if (hdr.mbrs == null) break;
                        if (Trace.trace) {
                            Trace.info("FD.up()", "[SUSPECT] suspect hdr is " + hdr);
                        }
                        int i = 0;
                        while (i < hdr.mbrs.size()) {
                            Address m = (Address)hdr.mbrs.elementAt(i);
                            if (this.local_addr != null && m.equals(this.local_addr)) {
                                Trace.warn("FD.up()", "I was suspected, but will not remove myself from membership (waiting for EXIT message)");
                            } else {
                                this.pingable_mbrs.remove(m);
                                this.ping_dest = (Address)this.getPingDest(this.pingable_mbrs);
                            }
                            this.passUp(new Event(9, m));
                            this.passDown(new Event(9, m));
                            ++i;
                        }
                        break;
                    }
                    case 3: {
                        if (!this.shun) break;
                        if (Trace.trace) {
                            Trace.info("FD.up()", "[NOT_MEMBER] I'm being shunned; exiting");
                        }
                        this.passUp(new Event(46));
                        break;
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                FD fD = this;
                synchronized (fD) {
                    this.stop();
                    View v = (View)evt.getArg();
                    this.members.removeAllElements();
                    this.members.addAll(v.getMembers());
                    this.bcast_task.adjustSuspectedMembers(this.members);
                    this.pingable_mbrs.removeAllElements();
                    this.pingable_mbrs.addAll(this.members);
                    this.passDown(evt);
                    this.ping_dest = (Address)this.getPingDest(this.pingable_mbrs);
                    if (this.ping_dest == null) return;
                    try {
                        this.startMonitor();
                    }
                    catch (Exception ex) {
                        Trace.warn("FD.down()", "exception when calling startMonitor(): " + ex);
                    }
                    return;
                }
            }
            case 51: {
                this.unsuspect((Address)evt.getArg());
                this.passDown(evt);
                return;
            }
        }
        this.passDown(evt);
    }

    void unsuspect(Address mbr) {
        this.bcast_task.removeSuspectedMember(mbr);
        this.pingable_mbrs.removeAllElements();
        this.pingable_mbrs.addAll(this.members);
        this.pingable_mbrs.removeAll(this.bcast_task.getSuspectedMembers());
        this.ping_dest = (Address)this.getPingDest(this.pingable_mbrs);
    }

    void shunInvalidHeartbeatSender(Address hb_sender) {
        int num_pings = 0;
        if (hb_sender != null && this.members != null && !this.members.contains(hb_sender)) {
            if (this.invalid_pingers.containsKey(hb_sender)) {
                num_pings = (Integer)this.invalid_pingers.get(hb_sender);
                if (num_pings >= this.max_tries) {
                    Trace.info("FD.shunInvalidHeartbeatSender()", "sender " + hb_sender + " is not member in " + this.members + " ! Telling it to leave group");
                    Message shun_msg = new Message(hb_sender, null, null);
                    shun_msg.putHeader(this.getName(), new FdHeader(3));
                    this.passDown(new Event(1, shun_msg));
                    this.invalid_pingers.remove(hb_sender);
                } else {
                    this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
                }
            } else {
                this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
            }
        }
    }

    private final /* synthetic */ void this() {
        this.ping_dest = null;
        this.local_addr = null;
        this.timeout = 3000L;
        this.last_ack = System.currentTimeMillis();
        this.num_tries = 0;
        this.max_tries = 2;
        this.members = new Vector();
        this.invalid_pingers = new Hashtable();
        this.pingable_mbrs = new Vector();
        this.shun = true;
        this.timer = null;
        this.monitor = null;
        this.bcast_task = new BroadcastTask();
    }

    public FD() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class FdHeader
    extends Header {
        static final int HEARTBEAT = 0;
        static final int HEARTBEAT_ACK = 1;
        static final int SUSPECT = 2;
        static final int NOT_MEMBER = 3;
        int type;
        Vector mbrs;
        Address from;

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "[FD: heartbeat]";
                }
                case 1: {
                    return "[FD: heartbeat ack]";
                }
                case 2: {
                    return "[FD: SUSPECT (suspected_mbrs=" + this.mbrs + ", from=" + this.from + ")]";
                }
                case 3: {
                    return "[FD: NOT_MEMBER]";
                }
            }
            return "[FD: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            if (this.mbrs == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(this.mbrs.size());
                Iterator it = this.mbrs.iterator();
                while (it.hasNext()) {
                    Address addr = (Address)it.next();
                    Marshaller.write(addr, out);
                }
            }
            Marshaller.write(this.from, out);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            boolean mbrs_not_null = in.readBoolean();
            if (mbrs_not_null) {
                int len = in.readInt();
                this.mbrs = new Vector();
                int i = 0;
                while (i < len) {
                    Address addr = (Address)Marshaller.read(in);
                    this.mbrs.add(addr);
                    ++i;
                }
            }
            this.from = (Address)Marshaller.read(in);
        }

        private final /* synthetic */ void this() {
            this.type = 0;
            this.mbrs = null;
            this.from = null;
        }

        public FdHeader() {
            this.this();
        }

        FdHeader(int type) {
            this.this();
            this.type = type;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Monitor
    implements TimeScheduler.Task {
        boolean started;

        public void stop() {
            this.started = false;
        }

        public boolean cancelled() {
            return this.started ^ true;
        }

        public long nextInterval() {
            return FD.this.timeout;
        }

        public void run() {
            long not_heard_from = 0L;
            if (FD.this.ping_dest == null) {
                Trace.error("FD.Monitor.run()", "ping_dest is null");
                return;
            }
            Message hb_req = new Message(FD.this.ping_dest, null, null);
            hb_req.putHeader(FD.this.getName(), new FdHeader(0));
            if (Trace.trace) {
                Trace.debug("FD.Monitor.run()", "sending are-you-alive msg to " + FD.this.ping_dest + " (own address=" + FD.this.local_addr + ')');
            }
            FD.this.passDown(new Event(1, hb_req));
            not_heard_from = System.currentTimeMillis() - FD.this.last_ack;
            if (not_heard_from > FD.this.timeout + 500L) {
                if (FD.this.num_tries >= FD.this.max_tries) {
                    if (Trace.trace) {
                        Trace.info("FD.Monitor.run()", "[" + FD.this.local_addr + "]: received no heartbeat ack from " + FD.this.ping_dest + " for " + FD.this.num_tries + "1 times, suspecting it");
                    }
                    FD.this.bcast_task.addSuspectedMember(FD.this.ping_dest);
                } else {
                    if (Trace.trace) {
                        Trace.debug("FD.Monitor.run()", "heartbeat missing from " + FD.this.ping_dest + " (number=" + FD.this.num_tries + ')');
                    }
                    ++FD.this.num_tries;
                }
            }
        }

        public String toString() {
            return "" + this.started;
        }

        private final /* synthetic */ void this() {
            this.started = true;
        }

        private Monitor() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BroadcastTask
    implements TimeScheduler.Task {
        Vector suspected_mbrs;
        boolean stopped;

        Vector getSuspectedMembers() {
            return this.suspected_mbrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD.this.members.contains(mbr)) {
                return;
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (!this.suspected_mbrs.contains(mbr)) {
                    this.suspected_mbrs.addElement(mbr);
                    if (Trace.trace) {
                        Trace.info("FD.BroadcastTask.addSuspectedMember()", "mbr=" + mbr + " (size=" + this.suspected_mbrs.size() + ')');
                    }
                }
                if (this.stopped && this.suspected_mbrs.size() > 0) {
                    this.stopped = false;
                    FD.this.timer.add(this, true);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            if (Trace.trace) {
                Trace.info("FD.BroadcastTask.removeSuspectedMember()", "member is " + suspected_mbr);
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeElement(suspected_mbr);
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void removeAll() {
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeAllElements();
                this.stopped = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void adjustSuspectedMembers(Vector new_mbrship) {
            if (new_mbrship == null || new_mbrship.size() == 0) {
                return;
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                Iterator it = this.suspected_mbrs.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        if (this.suspected_mbrs.size() == 0) {
                            this.stopped = true;
                        }
                        return;
                    }
                    Address suspected_mbr = (Address)it.next();
                    if (new_mbrship.contains(suspected_mbr)) continue;
                    it.remove();
                    if (!Trace.trace) continue;
                    Trace.info("FD.BroadcastTask.adjustSuspectedMembers()", "removed " + suspected_mbr + " (size=" + this.suspected_mbrs.size() + ')');
                }
            }
        }

        public boolean cancelled() {
            return this.stopped;
        }

        public long nextInterval() {
            return FD.this.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            FdHeader hdr;
            if (Trace.trace) {
                Trace.info("FD.BroadcastTask.run()", "broadcasting SUSPECT message [suspected_mbrs=" + this.suspected_mbrs + "] to group");
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                    if (Trace.trace) {
                        Trace.info("FD.BroadcastTask.run()", "task done (no suspected members)");
                    }
                    return;
                }
                hdr = new FdHeader(2);
                hdr.mbrs = (Vector)this.suspected_mbrs.clone();
                hdr.from = FD.this.local_addr;
            }
            Message suspect_msg = new Message();
            suspect_msg.putHeader(FD.this.getName(), hdr);
            FD.this.passDown(new Event(1, suspect_msg));
            if (Trace.trace) {
                Trace.info("FD.BroadcastTask.run()", "task done");
            }
        }

        private final /* synthetic */ void this() {
            this.suspected_mbrs = new Vector();
            this.stopped = false;
        }

        private BroadcastTask() {
            this.this();
        }
    }
}

