/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.stack.AckMcastSenderWindow;
import org.javagroups.stack.AckReceiverWindow;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMACK
extends Protocol
implements AckMcastSenderWindow.RetransmitCommand {
    static final String name = "SMACK";
    long[] timeout;
    int max_xmits;
    Vector members;
    AckMcastSenderWindow sender_win;
    HashMap receivers;
    HashMap xmit_table;
    Address local_addr;
    long seqno;
    long vid;
    boolean print_local_addr;

    public String getName() {
        return name;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("print_local_addr");
        if (str != null) {
            this.print_local_addr = new Boolean(str);
            props.remove("print_local_addr");
        }
        if ((str = props.getProperty("timeout")) != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            props.remove("timeout");
            if (tmp != null && tmp.length > 0) {
                this.timeout = tmp;
            }
        }
        if ((str = props.getProperty("max_xmits")) != null) {
            this.max_xmits = new Integer(str);
            props.remove("max_xmits");
        }
        if (props.size() > 0) {
            System.err.println("SMACK.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void stop() {
        if (this.sender_win != null) {
            this.sender_win.stop();
            this.sender_win = null;
        }
        Iterator it = this.receivers.values().iterator();
        while (it.hasNext()) {
            AckReceiverWindow win = (AckReceiverWindow)it.next();
            win.reset();
        }
        this.receivers.clear();
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.addMember(this.local_addr);
                if (!this.print_local_addr) break;
                System.out.println("\n-------------------------------------------------------\nGMS: address is " + this.local_addr + "\n-------------------------------------------------------");
                break;
            }
            case 3: {
                this.passUp(evt);
                this.sender_win = new AckMcastSenderWindow((AckMcastSenderWindow.RetransmitCommand)this, this.timeout);
                Message join_msg = new Message();
                join_msg.putHeader(name, new SmackHeader(3, -1));
                this.passDown(new Event(1, join_msg));
                return;
            }
            case 9: {
                if (Trace.trace) {
                    Trace.info("SMACK.up()", "removing suspected member " + evt.getArg());
                }
                this.removeMember((Address)evt.getArg());
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg == null) break;
                Address sender = msg.getSrc();
                SmackHeader hdr = (SmackHeader)msg.removeHeader(name);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        Message tmp_msg;
                        Message ack_msg = new Message(sender, null, null);
                        ack_msg.putHeader(name, new SmackHeader(2, hdr.seqno));
                        this.passDown(new Event(1, ack_msg));
                        Long tmp_seqno = new Long(hdr.seqno);
                        AckReceiverWindow win = (AckReceiverWindow)this.receivers.get(sender);
                        if (win == null) {
                            this.addMember(sender);
                            win = new AckReceiverWindow(hdr.seqno);
                            this.receivers.put(sender, win);
                        }
                        win.add(hdr.seqno, msg);
                        while ((tmp_msg = win.remove()) != null) {
                            this.passUp(new Event(1, tmp_msg));
                        }
                        return;
                    }
                    case 2: {
                        this.addMember(msg.getSrc());
                        this.sender_win.ack(hdr.seqno, msg.getSrc());
                        this.sender_win.clearStableMessages();
                        return;
                    }
                    case 3: {
                        if (Trace.trace) {
                            Trace.info("SMACK.up()", "received join announcement by " + msg.getSrc());
                        }
                        if (!this.containsMember(sender)) {
                            Message join_rsp = new Message(sender, null, null);
                            join_rsp.putHeader(name, new SmackHeader(3, -1));
                            this.passDown(new Event(1, join_rsp));
                        }
                        this.addMember(sender);
                        return;
                    }
                    case 4: {
                        if (Trace.trace) {
                            Trace.info("SMACK.up()", "received leave announcement by " + msg.getSrc());
                        }
                        this.removeMember(sender);
                        return;
                    }
                }
                Trace.warn("SMACK.up()", "detected SmackHeader with invalid type: " + hdr);
                break;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 4: {
                Message leave_msg = new Message();
                leave_msg.putHeader(name, new SmackHeader(4, -1));
                this.passDown(new Event(1, leave_msg));
                this.passUp(new Event(5));
                break;
            }
            case 2: {
                this.passUp(new Event(3));
                this.sender_win = new AckMcastSenderWindow((AckMcastSenderWindow.RetransmitCommand)this, this.timeout);
                Message join_msg = new Message();
                join_msg.putHeader(name, new SmackHeader(3, -1));
                this.passDown(new Event(1, join_msg));
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg == null || msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                msg.putHeader(name, new SmackHeader(1, this.seqno));
                this.sender_win.add(this.seqno, msg, (Vector)this.members.clone());
                ++this.seqno;
                break;
            }
        }
        this.passDown(evt);
    }

    public void retransmit(long seqno, Message msg, Address dest) {
        msg.setDest(dest);
        if (Trace.trace) {
            Trace.info("SMACK.retransmit()", seqno + ", msg=" + msg);
        }
        this.passDown(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addMember(Address mbr) {
        Vector vector = this.members;
        synchronized (vector) {
            if (mbr != null && !this.members.contains(mbr)) {
                this.members.addElement(mbr);
                Object tmp = this.members.clone();
                View new_view = new View(new ViewId(this.local_addr, this.vid++), (Vector)tmp);
                this.passUp(new Event(6, new_view));
                this.passDown(new Event(6, new_view));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeMember(Address mbr) {
        Vector vector = this.members;
        synchronized (vector) {
            if (mbr != null) {
                this.members.removeElement(mbr);
                Object tmp = this.members.clone();
                View new_view = new View(new ViewId(this.local_addr, this.vid++), (Vector)tmp);
                this.passUp(new Event(6, new_view));
                this.passDown(new Event(6, new_view));
                if (this.sender_win != null) {
                    this.sender_win.remove(mbr);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean containsMember(Address mbr) {
        Vector vector = this.members;
        synchronized (vector) {
            boolean bl = false;
            if (mbr == null) return bl;
            if (!this.members.contains(mbr)) return bl;
            return true;
        }
    }

    private final /* synthetic */ void this() {
        this.timeout = new long[]{1000L, 2000L, 3000L};
        this.max_xmits = 10;
        this.members = new Vector();
        this.sender_win = null;
        this.receivers = new HashMap();
        this.xmit_table = new HashMap();
        this.local_addr = null;
        this.seqno = 1L;
        this.vid = 1L;
        this.print_local_addr = true;
    }

    public SMACK() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class SmackHeader
    extends Header {
        public static final int MCAST = 1;
        public static final int ACK = 2;
        public static final int JOIN_ANNOUNCEMENT = 3;
        public static final int LEAVE_ANNOUNCEMENT = 4;
        int type;
        long seqno;

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.seqno);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.seqno = in.readLong();
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "MCAST";
                }
                case 2: {
                    return "ACK";
                }
                case 3: {
                    return "JOIN_ANNOUNCEMENT";
                }
                case 4: {
                    return "LEAVE_ANNOUNCEMENT";
                }
            }
            return "<unknown>";
        }

        private final /* synthetic */ void this() {
            this.type = 0;
            this.seqno = -1;
        }

        public SmackHeader() {
            this.this();
        }

        public SmackHeader(int type, long seqno) {
            this.this();
            this.type = type;
            this.seqno = seqno;
        }
    }
}

