/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols.pbcast;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Membership;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.pbcast.ClientGmsImpl;
import org.javagroups.protocols.pbcast.CoordGmsImpl;
import org.javagroups.protocols.pbcast.Digest;
import org.javagroups.protocols.pbcast.GmsImpl;
import org.javagroups.protocols.pbcast.JoinRsp;
import org.javagroups.protocols.pbcast.MergeData;
import org.javagroups.protocols.pbcast.ParticipantGmsImpl;
import org.javagroups.stack.Protocol;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GMS
extends Protocol {
    private GmsImpl impl;
    public Properties props;
    public Address local_addr;
    public String group_addr;
    public Membership members;
    public Membership tmp_members;
    public Vector joining;
    public ViewId view_id;
    public long ltime;
    public long join_timeout;
    public long join_retry_timeout;
    public long leave_timeout;
    public long digest_timeout;
    public long merge_timeout;
    public Object impl_mutex;
    private Object digest_mutex;
    private Digest digest;
    private Hashtable impls;
    private boolean shun;
    private boolean print_local_addr;
    boolean disable_initial_coord;
    final String CLIENT = "Client";
    final String COORD = "Coordinator";
    final String PART = "Participant";
    TimeScheduler timer;

    public String getName() {
        return "GMS";
    }

    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(12));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setImpl(GmsImpl new_impl) {
        Object object = this.impl_mutex;
        synchronized (object) {
            this.impl = new_impl;
            if (Trace.trace) {
                Trace.info("GMS.setImpl()", "changed role to " + new_impl.getClass().getName());
            }
            return;
        }
    }

    public GmsImpl getImpl() {
        return this.impl;
    }

    public void init() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("GMS.init(): timer is null");
        }
        if (this.impl != null) {
            this.impl.init();
        }
    }

    public void start() throws Exception {
        if (this.impl != null) {
            this.impl.start();
        }
    }

    public void stop() {
        if (this.impl != null) {
            this.impl.stop();
        }
    }

    public void becomeCoordinator() {
        CoordGmsImpl tmp = (CoordGmsImpl)this.impls.get("Coordinator");
        if (tmp == null) {
            tmp = new CoordGmsImpl(this);
            this.impls.put("Coordinator", tmp);
        }
        tmp.leaving = false;
        this.setImpl(tmp);
        if (Trace.trace) {
            Trace.info("GMS.becomeCoordinator()", this.local_addr + " became coordinator");
        }
    }

    public void becomeParticipant() {
        ParticipantGmsImpl tmp = (ParticipantGmsImpl)this.impls.get("Participant");
        if (tmp == null) {
            tmp = new ParticipantGmsImpl(this);
            this.impls.put("Participant", tmp);
        }
        tmp.leaving = false;
        this.setImpl(tmp);
        if (Trace.trace) {
            Trace.info("GMS.becomeParticipant()", this.local_addr + " became participant");
        }
    }

    public void becomeClient() {
        ClientGmsImpl tmp = (ClientGmsImpl)this.impls.get("Client");
        if (tmp == null) {
            tmp = new ClientGmsImpl(this);
            this.impls.put("Client", tmp);
        }
        tmp.initial_mbrs.removeAllElements();
        this.setImpl(tmp);
        if (Trace.trace) {
            Trace.info("GMS.becomeClient", this.local_addr + " became client");
        }
    }

    boolean haveCoordinatorRole() {
        boolean bl = false;
        if (this.impl != null && this.impl instanceof CoordGmsImpl) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public View getNextView(Vector new_mbrs, Vector old_mbrs, Vector suspected_mbrs) {
        long vid = 0L;
        Membership tmp_mbrs = null;
        Membership membership = this.members;
        synchronized (membership) {
            if (this.view_id == null) {
                Trace.error("GMS.getNextView()", "view_id is null");
                return null;
            }
            this.ltime = vid = Math.max(this.view_id.getId(), this.ltime) + 1L;
            if (Trace.trace) {
                Trace.debug("GMS.getNextView()", "VID=" + vid + ", current members=" + Util.printMembers(this.members.getMembers()) + ", new_mbrs=" + Util.printMembers(new_mbrs) + ", old_mbrs=" + Util.printMembers(old_mbrs) + ", suspected_mbrs=" + Util.printMembers(suspected_mbrs));
            }
            tmp_mbrs = this.tmp_members.copy();
            tmp_mbrs.remove(suspected_mbrs);
            tmp_mbrs.remove(old_mbrs);
            tmp_mbrs.add(new_mbrs);
            Vector mbrs = tmp_mbrs.getMembers();
            View v = new View(this.local_addr, vid, mbrs);
            this.tmp_members.set(mbrs);
            if (new_mbrs != null) {
                int i = 0;
                while (i < new_mbrs.size()) {
                    Address tmp_mbr = (Address)new_mbrs.elementAt(i);
                    if (!this.joining.contains(tmp_mbr)) {
                        this.joining.addElement(tmp_mbr);
                    }
                    ++i;
                }
            }
            if (Trace.trace) {
                Trace.debug("GMS.getNextView()", "new view is " + v);
            }
            return v;
        }
    }

    public View castViewChange(Vector new_mbrs, Vector old_mbrs, Vector suspected_mbrs) {
        View new_view = this.getNextView(new_mbrs, old_mbrs, suspected_mbrs);
        this.castViewChange(new_view);
        return new_view;
    }

    public void castViewChange(View new_view) {
        this.castViewChange(new_view, null);
    }

    public void castViewChange(View new_view, Digest digest) {
        if (Trace.trace) {
            Trace.info("GMS.castViewChange()", "mcasting view {" + new_view + "} (" + new_view.size() + " mbrs)\n");
        }
        Message view_change_msg = new Message();
        GmsHeader hdr = new GmsHeader(5, new_view);
        hdr.digest = digest;
        view_change_msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, view_change_msg));
    }

    public void installView(View new_view, Digest digest) {
        if (digest != null) {
            this.mergeDigest(digest);
        }
        this.installView(new_view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void installView(View new_view) {
        ViewId vid = new_view.getVid();
        Vector mbrs = new_view.getMembers();
        Membership membership = this.members;
        synchronized (membership) {
            int rc;
            this.ltime = Math.max(vid.getId(), this.ltime);
            if (!this.checkSelfInclusion(mbrs)) {
                if (Trace.trace) {
                    Trace.warn("GMS.installView()", "checkSelfInclusion() failed, not a member of view " + mbrs + "; discarding view");
                }
                if (this.shun) {
                    if (Trace.trace) {
                        Trace.warn("GMS.installView()", "I'm being shunned, will leave and rejoin group");
                    }
                    this.passUp(new Event(46));
                }
                return;
            }
            if (this.view_id != null && (rc = vid.compareTo(this.view_id)) <= 0) {
                Trace.error("GMS.installView()", "received view <= current view; discarding it ! (current vid: " + this.view_id + ", new vid: " + vid + ')');
                return;
            }
            if (Trace.trace) {
                Trace.info("GMS.installView()", "view is " + new_view);
            }
            this.view_id = vid.copy();
            if (mbrs != null && mbrs.size() > 0) {
                this.members.set(mbrs);
                this.tmp_members.set(this.members);
                this.joining.removeAll(mbrs);
                this.tmp_members.add(this.joining);
            }
            Event view_event = new Event(6, new_view.clone());
            this.passDown(view_event);
            this.passUp(view_event);
            Address coord = this.determineCoordinator();
            if (coord != null && coord.equals(this.local_addr) && !coord.equals(vid.getCoordAddress())) {
                this.becomeCoordinator();
            } else if (this.haveCoordinatorRole() && !this.local_addr.equals(coord)) {
                this.becomeParticipant();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Address determineCoordinator() {
        Membership membership = this.members;
        synchronized (membership) {
            if (this.members == null) return null;
            if (this.members.size() <= 0) return null;
            Address address = (Address)this.members.elementAt(0);
            return address;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean wouldBeNewCoordinator(Address potential_new_coord) {
        Address new_coord = null;
        if (potential_new_coord == null) {
            return false;
        }
        Membership membership = this.members;
        synchronized (membership) {
            if (this.members.size() < 2) {
                return false;
            }
            new_coord = (Address)this.members.elementAt(1);
            return new_coord != null && new_coord.equals(potential_new_coord);
            {
            }
        }
    }

    protected boolean checkSelfInclusion(Vector mbrs) {
        if (mbrs == null) {
            return false;
        }
        int i = 0;
        while (i < mbrs.size()) {
            Object mbr = mbrs.elementAt(i);
            if (mbr != null && this.local_addr.equals(mbr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public View makeView(Vector mbrs) {
        Address coord = null;
        long id = 0L;
        if (this.view_id != null) {
            coord = this.view_id.getCoordAddress();
            id = this.view_id.getId();
        }
        return new View(coord, id, mbrs);
    }

    public View makeView(Vector mbrs, ViewId vid) {
        Address coord = null;
        long id = 0L;
        if (vid != null) {
            coord = vid.getCoordAddress();
            id = vid.getId();
        }
        return new View(coord, id, mbrs);
    }

    public void setDigest(Digest d) {
        this.passDown(new Event(41, d));
    }

    public void mergeDigest(Digest d) {
        this.passDown(new Event(53, d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Digest getDigest() {
        Digest ret = null;
        Object object = this.digest_mutex;
        synchronized (object) {
            this.digest = null;
            this.passDown(new Event(39));
            try {
                this.digest_mutex.wait(this.digest_timeout);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.digest != null) {
                ret = this.digest;
                this.digest = null;
                return ret;
            }
            Trace.error("GMS.getDigest()", "digest could not be fetched from PBCAST layer");
            return null;
        }
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof GmsHeader)) break;
                GmsHeader hdr = (GmsHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        this.handleJoinRequest(hdr.mbr);
                        break;
                    }
                    case 2: {
                        this.impl.handleJoinResponse(hdr.join_rsp);
                        break;
                    }
                    case 3: {
                        if (Trace.trace) {
                            Trace.info("GMS.up()", "received LEAVE_REQ " + hdr + " from " + msg.getSrc());
                        }
                        if (hdr.mbr == null) {
                            if (Trace.trace) {
                                Trace.error("GMS.up()", "LEAVE_REQ's mbr field is null");
                            }
                            return;
                        }
                        this.sendLeaveResponse(hdr.mbr);
                        this.impl.handleLeave(hdr.mbr, false);
                        break;
                    }
                    case 4: {
                        this.impl.handleLeaveResponse();
                        break;
                    }
                    case 5: {
                        if (hdr.view == null) {
                            Trace.error("GMS.up()", "[VIEW]: view == null");
                            return;
                        }
                        this.impl.handleViewChange(hdr.view, hdr.digest);
                        break;
                    }
                    case 6: {
                        this.impl.handleMergeRequest(msg.getSrc(), hdr.merge_id);
                        break;
                    }
                    case 7: {
                        MergeData merge_data = new MergeData(msg.getSrc(), hdr.view, hdr.digest);
                        merge_data.merge_rejected = hdr.merge_rejected;
                        this.impl.handleMergeResponse(merge_data, hdr.merge_id);
                        break;
                    }
                    case 8: {
                        this.impl.handleMergeView(new MergeData(msg.getSrc(), hdr.view, hdr.digest), hdr.merge_id);
                        break;
                    }
                    case 9: {
                        this.impl.handleMergeCancelled(hdr.merge_id);
                        break;
                    }
                    default: {
                        Trace.error("GMS.up()", "GmsHeader with type=" + hdr.type + " not known");
                    }
                }
                return;
            }
            case 3: 
            case 5: {
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                if (!this.print_local_addr) break;
                System.out.println("\n-------------------------------------------------------\nGMS: address is " + this.local_addr + "\n-------------------------------------------------------");
                break;
            }
            case 9: {
                this.impl.suspect((Address)evt.getArg());
                break;
            }
            case 51: {
                this.impl.unsuspect((Address)evt.getArg());
                return;
            }
            case 14: {
                this.impl.merge((Vector)evt.getArg());
                return;
            }
        }
        if (this.impl.handleUpEvent(evt)) {
            this.passUp(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receiveUpEvent(Event evt) {
        if (evt.getType() != 40) {
            super.receiveUpEvent(evt);
            return;
        }
        Object object = this.digest_mutex;
        synchronized (object) {
            this.digest = (Digest)evt.getArg();
            this.digest_mutex.notifyAll();
            return;
        }
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 2: {
                this.passDown(evt);
                try {
                    this.group_addr = (String)evt.getArg();
                }
                catch (ClassCastException cce) {
                    Trace.error("GMS.down()", "[CONNECT]: group address must be a string (channel name)");
                }
                if (this.local_addr == null) {
                    Trace.fatal("GMS.down()", "[CONNECT] local_addr is null");
                }
                this.impl.join(this.local_addr);
                this.passUp(new Event(3));
                return;
            }
            case 4: {
                this.impl.leave((Address)evt.getArg());
                this.passUp(new Event(5));
                this.initState();
                break;
            }
        }
        if (this.impl.handleDownEvent(evt)) {
            this.passDown(evt);
        }
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("shun");
        if (str != null) {
            this.shun = new Boolean(str);
            props.remove("shun");
        }
        if ((str = props.getProperty("print_local_addr")) != null) {
            this.print_local_addr = new Boolean(str);
            props.remove("print_local_addr");
        }
        if ((str = props.getProperty("join_timeout")) != null) {
            this.join_timeout = new Long(str);
            props.remove("join_timeout");
        }
        if ((str = props.getProperty("join_retry_timeout")) != null) {
            this.join_retry_timeout = new Long(str);
            props.remove("join_retry_timeout");
        }
        if ((str = props.getProperty("leave_timeout")) != null) {
            this.leave_timeout = new Long(str);
            props.remove("leave_timeout");
        }
        if ((str = props.getProperty("merge_timeout")) != null) {
            this.merge_timeout = new Long(str);
            props.remove("merge_timeout");
        }
        if ((str = props.getProperty("digest_timeout")) != null) {
            this.digest_timeout = new Long(str);
            props.remove("digest_timeout");
        }
        if ((str = props.getProperty("disable_initial_coord")) != null) {
            this.disable_initial_coord = new Boolean(str);
            props.remove("disable_initial_coord");
        }
        if (props.size() > 0) {
            System.err.println("GMS.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    void initState() {
        this.becomeClient();
        this.view_id = null;
    }

    void handleJoinRequest(Address mbr) {
        JoinRsp join_rsp;
        if (mbr == null) {
            if (Trace.trace) {
                Trace.error("GMS.handleJoinRequest()", "mbr is null");
            }
            return;
        }
        if (Trace.trace) {
            Trace.debug("GMS.handleJoinRequest()", "mbr=" + mbr);
        }
        if ((join_rsp = this.impl.handleJoin(mbr)) == null) {
            Trace.error("GMS.handleJoinRequest()", this.impl.getClass().toString() + ".handleJoin(" + mbr + ") returned null: will not be able to multicast new view");
        }
        if (join_rsp != null && join_rsp.getView() != null) {
            this.passDown(new Event(15, join_rsp.getView()));
        }
        Message m = new Message(mbr, null, null);
        GmsHeader hdr = new GmsHeader(2, join_rsp);
        m.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, m));
        if (join_rsp != null) {
            this.castViewChange(join_rsp.getView());
        }
    }

    void sendLeaveResponse(Address mbr) {
        Message msg = new Message(mbr, null, null);
        GmsHeader hdr = new GmsHeader(4);
        msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, msg));
    }

    private final /* synthetic */ void this() {
        this.impl = null;
        this.props = null;
        this.local_addr = null;
        this.group_addr = null;
        this.members = new Membership();
        this.tmp_members = new Membership();
        this.joining = new Vector();
        this.view_id = null;
        this.ltime = 0L;
        this.join_timeout = 5000L;
        this.join_retry_timeout = 2000L;
        this.leave_timeout = 5000L;
        this.digest_timeout = 5000L;
        this.merge_timeout = 10000L;
        this.impl_mutex = new Object();
        this.digest_mutex = new Object();
        this.digest = null;
        this.impls = new Hashtable();
        this.shun = true;
        this.print_local_addr = true;
        this.disable_initial_coord = false;
        this.CLIENT = "Client";
        this.COORD = "Coordinator";
        this.PART = "Participant";
        this.timer = null;
    }

    public GMS() {
        this.this();
        this.initState();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class GmsHeader
    extends Header {
        public static final int JOIN_REQ = 1;
        public static final int JOIN_RSP = 2;
        public static final int LEAVE_REQ = 3;
        public static final int LEAVE_RSP = 4;
        public static final int VIEW = 5;
        public static final int MERGE_REQ = 6;
        public static final int MERGE_RSP = 7;
        public static final int INSTALL_MERGE_VIEW = 8;
        public static final int CANCEL_MERGE = 9;
        int type;
        View view;
        Address mbr;
        JoinRsp join_rsp;
        Digest digest;
        Serializable merge_id;
        boolean merge_rejected;

        public String toString() {
            StringBuffer sb = new StringBuffer("GmsHeader");
            sb.append("[" + GmsHeader.type2String(this.type) + ']');
            switch (this.type) {
                case 1: {
                    sb.append(": mbr=" + this.mbr);
                    break;
                }
                case 2: {
                    sb.append(": join_rsp=" + this.join_rsp);
                    break;
                }
                case 3: {
                    sb.append(": mbr=" + this.mbr);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    sb.append(": view=" + this.view);
                    break;
                }
                case 6: {
                    sb.append(": merge_id=" + this.merge_id);
                    break;
                }
                case 7: {
                    sb.append(": view=" + this.view + ", digest=" + this.digest + ", merge_rejected=" + this.merge_rejected + ", merge_id=" + this.merge_id);
                    break;
                }
                case 8: {
                    sb.append(": view=" + this.view + ", digest=" + this.digest);
                    break;
                }
                case 9: {
                    sb.append(", <merge cancelled>, merge_id=" + this.merge_id);
                    break;
                }
            }
            sb.append("\n");
            return sb.toString();
        }

        public static String type2String(int type) {
            switch (type) {
                case 1: {
                    return "JOIN_REQ";
                }
                case 2: {
                    return "JOIN_RSP";
                }
                case 3: {
                    return "LEAVE_REQ";
                }
                case 4: {
                    return "LEAVE_RSP";
                }
                case 5: {
                    return "VIEW";
                }
                case 6: {
                    return "MERGE_REQ";
                }
                case 7: {
                    return "MERGE_RSP";
                }
                case 8: {
                    return "INSTALL_MERGE_VIEW";
                }
                case 9: {
                    return "CANCEL_MERGE";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeObject(this.view);
            out.writeObject(this.mbr);
            out.writeObject(this.join_rsp);
            out.writeObject(this.digest);
            out.writeObject(this.merge_id);
            out.writeBoolean(this.merge_rejected);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.view = (View)in.readObject();
            this.mbr = (Address)in.readObject();
            this.join_rsp = (JoinRsp)in.readObject();
            this.digest = (Digest)in.readObject();
            this.merge_id = (Serializable)in.readObject();
            this.merge_rejected = in.readBoolean();
        }

        private final /* synthetic */ void this() {
            this.type = 0;
            this.view = null;
            this.mbr = null;
            this.join_rsp = null;
            this.digest = null;
            this.merge_id = null;
            this.merge_rejected = false;
        }

        public GmsHeader() {
            this.this();
        }

        public GmsHeader(int type) {
            this.this();
            this.type = type;
        }

        public GmsHeader(int type, View view) {
            this.this();
            this.type = type;
            this.view = view;
        }

        public GmsHeader(int type, Address mbr) {
            this.this();
            this.type = type;
            this.mbr = mbr;
        }

        public GmsHeader(int type, JoinRsp join_rsp) {
            this.this();
            this.type = type;
            this.join_rsp = join_rsp;
        }
    }
}

