/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.JChannel;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FragTestUnicast {
    int mode;
    Channel channel;
    String props;
    int i;
    Message msg;
    Object obj;
    int MSG_SIZE;
    String groupname;
    char sendingChar;
    int num_msgs;
    long timeout;
    int frag_size;
    Address local_addr;

    public void start() throws Exception {
        Address receiver = null;
        Trace.init();
        this.channel = new JChannel(this.props);
        this.channel.connect(this.groupname);
        this.local_addr = this.channel.getLocalAddress();
        if (this.mode == 1) {
            Vector mbrs = this.channel.getView().getMembers();
            if (mbrs.size() < 2) {
                View view;
                Object obj;
                System.out.println("Waiting for receiver to join group");
                while (!((obj = this.channel.receive(0L)) instanceof View) || (mbrs = (view = (View)obj).getMembers()).size() < 2) {
                }
            }
            int i = 0;
            while (i < mbrs.size()) {
                if (!mbrs.elementAt(i).equals(this.local_addr)) {
                    receiver = (Address)mbrs.elementAt(i);
                    break;
                }
                ++i;
            }
            System.out.println("Receiver joined group: I'm starting to send messages to " + receiver);
            int j = 0;
            while (j < this.num_msgs) {
                this.msg = this.createBigMessage(this.MSG_SIZE);
                this.msg.setDest(receiver);
                System.out.println("Sending msg (" + this.MSG_SIZE + " bytes) to " + receiver);
                this.channel.send(this.msg);
                System.out.println("Done Sending msg (" + this.MSG_SIZE + " bytes)");
                Util.sleep(this.timeout);
                ++j;
            }
        } else {
            System.out.println("Waiting for messages:");
            while (true) {
                try {
                    Object obj = this.channel.receive(0L);
                    if (!(obj instanceof Message)) continue;
                    System.out.println("Received message: " + obj);
                    Message tmp = (Message)obj;
                    byte[] buf = tmp.getBuffer();
                    int i = 0;
                    while (i < (10 < this.MSG_SIZE ? 10 : this.MSG_SIZE)) {
                        System.out.print((char)buf[i]);
                        ++i;
                    }
                    System.out.println();
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
        System.out.println("Press [return] to exit");
        System.in.read();
        this.channel.close();
    }

    Message createBigMessage(int size) {
        byte[] buf = new byte[size];
        int i = 0;
        while (i < buf.length) {
            buf[i] = (byte)this.sendingChar;
            ++i;
        }
        return new Message(null, null, buf);
    }

    public static void main(String[] args) {
        char defaultChar = 'A';
        int default_mode = 0;
        int MSG_SIZE = 30000;
        int num_msgs = 5;
        long timeout = 1000L;
        int frag_size = 8195;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-help")) {
                FragTestUnicast.usage();
                return;
            }
            if (args[i].equals("-sender")) {
                default_mode = 1;
            } else if (args[i].equals("-size")) {
                MSG_SIZE = Integer.parseInt(args[++i]);
            } else if (args[i].equals("-num_msgs")) {
                num_msgs = Integer.parseInt(args[++i]);
            } else if (args[i].equals("-frag_size")) {
                frag_size = Integer.parseInt(args[++i]);
            } else if (args[i].equals("-timeout")) {
                timeout = Long.parseLong(args[++i]);
            } else if (args[i].equals("-char")) {
                defaultChar = args[++i].charAt(0);
            } else {
                FragTestUnicast.usage();
                return;
            }
            ++i;
        }
        try {
            new FragTestUnicast(defaultChar, default_mode, MSG_SIZE, num_msgs, timeout, frag_size).start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void usage() {
        System.out.println("FragTestUnicast [-sender] [-size <message size (in bytes)>] [-timeout <msecs>] [-num_msgs <number of messages>] [-char <frag character>] [-frag_size <fragmentation size>] [-help]");
    }

    private final /* synthetic */ void this() {
        this.mode = 0;
        this.i = 1;
        this.groupname = "FragTestUnicastGroup";
        this.num_msgs = 10;
        this.timeout = 3000L;
        this.frag_size = 20000;
    }

    public FragTestUnicast(char character, int mode, int msg_size, int num_msgs, long timeout, int frag_size) {
        this.this();
        this.sendingChar = character;
        this.mode = mode;
        this.MSG_SIZE = msg_size;
        this.num_msgs = num_msgs;
        this.timeout = timeout;
        this.frag_size = frag_size;
        this.props = "UDP(mcast_addr=224.10.20.3;mcast_port=45566;ip_ttl=32;ucast_send_buf_size=" + frag_size * 2 + ";ucast_recv_buf_size=" + frag_size * 4 + "):PING(timeout=3000;num_initial_members=2):FD(timeout=5000):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=20;retransmit_timeout=2000):UNICAST(timeout=4000):pbcast.STABLE(desired_avg_gossip=10000):FRAG(frag_size=" + frag_size + "):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
    }
}

