#!/bin/sh

# called with '--upstream-version' <version>
VERSION=$2
TAR=../osgi-core_$VERSION.orig.tar.gz
DIR=osgi-core-$VERSION
TAG=43

wget -O osgi.core.jar http://www.osgi.org/download/r4v$TAG/osgi.core-${VERSION}.jar

mkdir -p $DIR/src/
(cd $DIR && jar xvf ../osgi.core.jar)

rm -r $DIR/org
mv $DIR/OSGI-OPT/src/* $DIR/src/
mv $DIR/OSGI-OPT/*.bnd $DIR/src/
mv $DIR/META-INF $DIR/src/
rm -r $DIR/OSGI-OPT

GZIP=--best tar -c -z -f $TAR --exclude '*.jar' --exclude '*.class' $DIR
rm -rf $DIR osgi.core.jar
