
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/******************************************************************************
**
**    File:      string_list.h
**    Author:    Brian Wotring
**
**    Date:      June 22, 2001.
**    Project:   osiris
**
******************************************************************************/

#ifndef STRING_LIST_H
#define STRING_LIST_H

#define INITIAL_LIST_SIZE 100


/* string list structure. */

typedef struct string_list
{
    char **list;

    unsigned int size;
    unsigned int max_size;

} string_list;


/* function prototypes */

string_list * string_list_new();
void string_list_destroy( string_list *list );

int string_list_add_item( string_list *list, const char *item );
int string_list_get_total_length( string_list *list );

osi_bool string_list_contains_item( string_list *list, const char *item,
                                    osi_bool case_sensitive );

osi_bool string_list_remove_index( string_list *list, int index );

void string_list_double_size( string_list *list );
void string_list_dump( string_list *list );


#endif

