
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    windows_service.h
**  Date:    August 7, 2002
**
**  Author:  Brian Wotring
**  Purpose: install and control this daemon as a service.
**
******************************************************************************/

#ifndef WINDOWS_SERVICE_H_
#define WINDOWS_SERVICE_H_

#ifdef WIN32

/* windows service paramaters.                   */
/* name of the executable, service, display name */
/* and the dependency list.                      */


#define SERVICE_APP_NAME	    "osirisd.exe"
#define SERVICE_NAME		    "osirisd"
#define SERVICE_DISPLAY_NAME 	"Osiris Scan Agent"
#define SERVICE_DEPENDENCIES     ""

void install_windows_service();
void uninstall_windows_service();

/* service control handlers for windows. */

void service_start( DWORD dwArgc, LPTSTR *lpszArgv );
void service_stop();

void WINAPI service_main( DWORD dwArgc, LPTSTR *lpszArgv );

BOOL ReportStatusToSCMgr( DWORD dwCurrentState, DWORD dwWin32ExitCode,
                          DWORD dwWaitHint );

void AddToMessageLog( LPTSTR lpszMsg );

/* externs for osirisd that needs to know about these. */

extern unsigned __stdcall run( void *unused );
extern HANDLE hEvents[2];

#endif /* WIN32 */

#endif
