
/******************************************************************************
**
**  Copyright (C) 2005 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_notify.h
**  Date:    July 1, 2003
**
**  Author:  Brian Wotring
**  Purpose: notify admin of scan logs, initially this will be via email.
**
******************************************************************************/

#ifndef MD_NOTIFY_H_
#define MD_NOTIFY_H_

#define CTX_PAYLOAD_LENGTH 8192
#define CTX_HEADERS_LENGTH 4096

#define NOTIFY_TYPE_TEST            1
#define NOTIFY_TYPE_REKEY           2
#define NOTIFY_TYPE_LOG             3
#define NOTIFY_TYPE_SCHEDULE_FAIL   4
#define NOTIFY_TYPE_REPORT          5

/* all the random crap possibly used when sending a notification. */

typedef struct MD_NOTIFY_CTX
{
    int type;
    int diff_count;

    char *host;
    char *email;
    char *message;
    char *filename;
    char *db_name;

    char hostname[MAX_HOSTNAME_LENGTH];
    char headers[CTX_HEADERS_LENGTH];
    char payload[CTX_PAYLOAD_LENGTH];

    osi_bool show_url;
    OSI_ERROR error;

} MD_NOTIFY_CTX;

void md_notify_init( MD_NOTIFY_CTX *ctx, int type );
void md_notify( MD_NOTIFY_CTX *ctx );

#endif

