
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/******************************************************************************
**
**    File:      filter.h
**    Author:    Brian Wotring
**
**    Date:      March 14, 2002.
**    Project:   osiris
**
******************************************************************************/

#ifndef FILTER_H
#define FILTER_H

#define MAX_FILTER_NAME_LENGTH         	 20
#define MAX_FILTER_ARGUMENT_LENGTH       MAX_PATH_LENGTH

/* filter types */

/* currently, unknown translates to IncludeAll. */

#define FILTER_TYPE_UNKNOWN              0
#define FILTER_TYPE_STICKY               1
#define FILTER_TYPE_SUID                 2
#define FILTER_TYPE_SGID                 3
#define FILTER_TYPE_EXECUTABLE           4
#define FILTER_TYPE_PERL                 5
#define FILTER_TYPE_PYTHON               6
#define FILTER_TYPE_SCRIPT               7
#define FILTER_TYPE_GZIP                 8
#define FILTER_TYPE_ZIP                  9
#define FILTER_TYPE_TAR                 10
#define FILTER_TYPE_PGP                 11
#define FILTER_TYPE_RPM                 12

#define FILTER_TYPE_UID                 13
#define FILTER_TYPE_GID                 14
#define FILTER_TYPE_USER                15
#define FILTER_TYPE_GROUP               16
#define FILTER_TYPE_HEADER              17
#define FILTER_TYPE_FILE                18
#define FILTER_TYPE_SUFFIX              19
#define FILTER_TYPE_MD5                 20
#define FILTER_TYPE_SHA                 21
#define FILTER_TYPE_RIPEMD              22
#define FILTER_TYPE_PERMISSIONS         23
#define FILTER_TYPE_SID                 24


struct keywords
{
    char *word;
    int  type;
};


typedef struct FILTER_CONTEXT
{
    /* storage of file related data. */
    
    SCAN_RECORD *scan_record;
    struct stat *file_stats;
    
    /* argument, for dynamic filters. */
    
    unsigned char *filter_argument;
    
    /* keep handle, possibly open, to only have to open the */
    /* file once, and the header value, so we only have to  */
    /* read that value once.                                */
    
    FILE *file_handle;
    unsigned char file_header[MAX_FILTER_ARGUMENT_LENGTH];
    
} FILTER_CONTEXT;



typedef struct OSI_FILTER
{
    int type;
    char argument[MAX_FILTER_ARGUMENT_LENGTH];

    osi_bool (*perform)( const char *file_path, FILTER_CONTEXT *context );

} OSI_FILTER;




int setup_filter_function( OSI_FILTER *action_filter, int type );
osi_bool filter_is_dynamic( int filter_type );

int get_filter_type( char *line );

char * get_filter_value( char *line, char *value );
char *get_filter_name_from_type( int filter_type );


/* static filters. */

osi_bool filter_sticky( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_suid( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_sgid( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_executable( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_perl( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_python( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_script( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_gzip( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_zip( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_tar( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_pgp( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_rpm( const char *file_path, FILTER_CONTEXT *context );

/* dynamic filters with arguments. */

osi_bool filter_uid( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_gid( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_sid( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_user( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_group( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_header( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_file( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_suffix( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_md5( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_sha( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_ripemd( const char *file_path, FILTER_CONTEXT *context );
osi_bool filter_permissions( const char *file_path, FILTER_CONTEXT *context );

#endif
