
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/******************************************************************************
**
**    File:      osi_common.h
**    Author:    Brian Wotring
**
**    Date:      June 22, 2001.
**    Project:   osiris
**
******************************************************************************/

#ifndef OSI_COMMON_H
#define OSI_COMMON_H

#include "config.h"

/* for atomic_t */
#include <signal.h>

typedef int osi_bool;

#ifndef FALSE
#define FALSE   0
#endif

#ifndef TRUE
#define TRUE    !FALSE
#endif

#ifdef WIN32
#define PATH_SEPARATOR '\\'
#else
#define PATH_SEPARATOR '/'
#endif

#define MAX_PATH_LENGTH 256
#define MAX_SCAN_RECORD_LENGTH 1024


#ifdef  MAXHOSTNAMELEN
#define MAX_HOSTNAME_LENGTH	MAXHOSTNAMELEN
#else
#define MAX_HOSTNAME_LENGTH	256
#endif

/* setup some type definitions so we have a best attempt */
/* at knowning the actual sizes of these data types.     */

#ifdef HAVE_U_INT16_T
typedef u_int16_t osi_uint16;
#else
typedef unsigned short osi_uint16;
#endif

#ifdef HAVE_U_INT32_T
typedef u_int32_t osi_uint32;
#else
typedef unsigned int osi_uint32;
#endif

#ifdef HAVE_U_INT64_T
typedef u_int64_t osi_uint64;
#else
#ifdef WIN32
typedef __int64 osi_uint64;
#else
typedef long long osi_uint64;
#endif
#endif

#ifdef HAVE_SIG_ATOMIC_T
typedef sig_atomic_t osi_atomic_t;
#else
typedef int osi_atomic_t;
#endif


/* define some limits for these.  They should be recognizable */
/* within this size constraint.                               */

#define GROUPNAME_LENGTH            20
#define USERNAME_LENGTH             20

#define SID_LENGTH                  100

#define PERMISSIONS_STRING_LENGTH	11
#define MAX_CHECKSUM_LENGTH         41

/* for checksums */

#define BUFFER_SIZE 	    (1024*16)
#define RMDsize 			160

/* used ports. */

#define DEFAULT_SCAN_AGENT_PORT     2265
#define DEFAULT_CONSOLE_PORT        2266
#define DEFAULT_CONSOLE_HTTP_PORT   0

#endif

